
#include "SwarmTaxisIface.h"
#include <assert.h>

SwarmTaxisIface::SwarmTaxisIface() {
	reached = false;
	linearSpeed = 0;
	angularSpeed = 0;
	desiredTurningDegree = 0;
	degreeTurned = 0;
	avoidanceRadius = 0;
	
	anyRobotToAvoid = false;
}

void SwarmTaxisIface::MoveForward(double i) {

	assert(i > 0);

	enum State {S, F};
	static int currentState = S;

	if (currentState == F) {currentState = S;}

	switch (currentState) {
		case S:
			linearSpeed = i;
			angularSpeed = 0;
			break;
		default:
			break;
	}

	switch (currentState) {
		case S:
			currentState = F;
			break;
		default:
			break;
	}
}

void SwarmTaxisIface::RotateClockwise(double i) {

	assert(i < 0);

	enum State {S, F};
	static int currentState = S;

	if (currentState == F) {currentState = S;}

	switch (currentState) {
		case S:
			linearSpeed = 0;
			angularSpeed = i;
			break;
		default:
			break;
	}

	switch (currentState) {
		case S:
			currentState = F;
			break;
		default:
			break;
	}
}

void SwarmTaxisIface::RotateAntiClockwise(double i) {

	assert(i > 0);

	enum State {S, F};
	static int currentState = S;

	if (currentState == F) {currentState = S;}

	switch (currentState) {
		case S:
			linearSpeed = 0;
			angularSpeed = i;
			break;
		default:
			break;
	}

	switch (currentState) {
		case S:
			currentState = F;
			break;
		default:
			break;
	}
}

void SwarmTaxisIface::Turn() {
	enum state {S, F};
	static int currentState = S;

	if (currentState == F) {currentState = S;}

	switch (currentState) {
	case S:
		if (desiredTurningDegree <= 0) {
			RotateClockwise(-2.51);
		}
		else {
			RotateAntiClockwise(2.51);
		}
		degreeTurned = degreeTurned + angularSpeed * 0.1;
		if (desiredTurningDegree < 0 && degreeTurned < desiredTurningDegree) {reached = true; degreeTurned = 0;}
		else {}
		if (desiredTurningDegree > 0 && degreeTurned > desiredTurningDegree) {reached = true; degreeTurned = 0;}
		else {}
		break;
	default:
		break;
	}

	switch (currentState) {
		case S:
			currentState = F;
			break;
		default:
			break;
	}
}

void SwarmTaxisIface::UpdateAvoidanceRadius() {
	bool illuminated;
	illuminated = CheckIlluminationStatus();

	enum state {S, F};
	static int currentState = S;

	if (currentState == F) {currentState = S;}

	switch (currentState) {
		case S:
			if (illuminated == true) {
				avoidanceRadius = 0.2;
			}
			else {
				avoidanceRadius = 0.1;
			}
			break;
		default:
			break;
	}

	switch (currentState) {
		case S:
			currentState = F;
			break;
		default:
			break;
	}
}




