
#ifndef AGGREGATIONIFACE_H_
#define AGGREGATIONIFACE_H_

class AggregationIface {

	private:
		double linearSpeed;
		double angularSpeed;

	protected:
		bool seeWall, seeRobot;

	public:

		void SetLinearSpeed (double i) {linearSpeed = i;}
		void SetAngularSpeed (double i) {angularSpeed = i;}
		double GetLinearSpeed () {return linearSpeed;}
		double GetAngularSpeed () {return angularSpeed;}

		void RaiseSeeWall() {seeWall = true;}
		void RaiseSeeRobot() {seeRobot = true;}

		AggregationIface();
		virtual void MoveClockwise(double i, double j);
		virtual void RotateClockwise(double i);
};

#endif

