
#include "AggregationIface.h"
#include <assert.h>

AggregationIface::AggregationIface() {
	linearSpeed = 0;
	angularSpeed = 0;

	seeWall = false;
	seeRobot = false;
}

void AggregationIface::MoveClockwise(double i, double j) {

	assert ((i != 0) && (j < 0));
	enum State {S, F};
	static int currentState = S;

	if (currentState == F) {currentState = S;}

	switch (currentState) {
		case S:
			linearSpeed = i;
			angularSpeed = j;
			break;
		default:
			break;
	}

	switch (currentState) {
		case S:
			currentState = F;
			break;
		default:
			break;
	}
}

void AggregationIface::RotateClockwise(double i) {

	assert(i < 0);
	enum State {S, F};
	static int currentState = S;

	if (currentState == F) {currentState = S;}

	switch (currentState) {
		case S:
			linearSpeed = 0;
			angularSpeed = i;
			break;
		default:
			break;
	}

	switch (currentState) {
		case S:
			currentState = F;
			break;
		default:
			break;
	}
}




