
#include "AggregationFSM.h"

AggregationFSM::AggregationFSM()
{
	currentState = S1;
}

void AggregationFSM::MakeTransition() {
	switch (currentState) {
		case S1:
			if (seeRobot) {
				currentState = S2;
			}
			break;
		case S2:
			if (seeWall) {
				currentState = S1;
			}
			break;
		default:
			break;
	}
}

void AggregationFSM::ExecuteEntryAction() {
	switch (currentState) {
		case S1:
			Entry_Action_S1();
		    break;
		case S2:
			Entry_Action_S2();
			break;
		default:
			break;
	}
}

void AggregationFSM::ClearEvents() {
	seeWall = false;
	seeRobot = false;
}

void AggregationFSM::RunAggregationFSM() {
	ExecuteEntryAction();
	MakeTransition();
	ClearEvents();
}

void AggregationFSM::Entry_Action_S1() {
	MoveClockwise(-10.88, -0.75);
}

void AggregationFSM::Entry_Action_S2() {
	RotateClockwise(-5.02);
}







