function [rxTxTraj] = waymarkTrajGenBellhopFunc200(time)
% Function to generate the depth of the receiver and transmitter and
% the range between them over time.
% Where:
%	rxDepth, receiver depths at each waymark (m)
%	txDepth, transmitter depths at each waymark (m)
%	rxTxRange, range between the receiver and transmitter at each waymark (m)
%
%	T_WAYMARK, trajectory sampling interval
%	NUM_WAYMARKS, number of waymarks generated
%	WAYMARK_SPLINE_PAD, the number of waymarks added to allow for the interpolation at the begining and end




% Generate the receiver depth
% ===========================
% Constant receiver depth
RX_A = 100;	% Depth in meters
rxTxTraj.rxDepth = RX_A;


% Generate the transmitter depth
% ==============================
% % Generate a simple straight line txDepth = Ax + B
% TX_A = 0.01;
% TX_B = 10;
% rxTxTraj.txDepth = (TX_A*time) + TX_B;	% generate waymark depths
% Constant transmitter depth
TX_A = 100;	% Depth in meters
rxTxTraj.txDepth = TX_A;


% Generate the receiver - transmitter range
% =========================================
% Generate second order curve rxTxRange = Ax^2 + Bx + C
% RXTX_A = 0.001;
% RXTX_AT = (3/4)*(NUM_WAYMARKS-1)*T_WAYMARK;
% RXTX_B = 0;
% RXTX_C = 1000;
% rxTxTraj.rxTxRange = [	(RXTX_A*((time-RXTX_AT).^2) + RXTX_B*time + RXTX_C); ...
% 								(RXTX_A*((time-RXTX_AT).^2) + RXTX_B*time + RXTX_C)];

% Generate a simple straight line rxTxRange = Ax + B
RXTX_A = 5;
RXTX_B = 1000;
rxTxTraj.rxTxRange = (RXTX_A*time) + RXTX_B;	% generate waymark depths


