% This script plots the data from a saved experiment .mat file and then exports it as a .eps and .pdf

PRINT_PLOT = false;
experimentTagFig = [experimentName, '_', srcData.waveformName];

 

% Arrival data for the first waymark
% ==================================

% Plot the magnitude and phase angle for the arrivals at a waymark.
freqFieldTrajFig = figure('name', ['Waymark arrivals, Waymark: ' num2str(waymarkIndex)]);
subplot(3,1,1);
plot(field.srcAngle, field.delay, '+');
title(['Field delay-angle, Waymark: ' num2str(waymarkIndex)])
ylabel('Delay time (s)')
xlabel('Angle')

subplot(3,1,2);
plot(field.srcAngle, abs(field.amp), '+');
title(['Field amplitude-angle, Waymark: ' num2str(waymarkIndex)])
ylabel('Amplitude')
xlabel('Angle')


subplot(3,1,3);
plot(field.srcAngle, angle(field.amp), '+');
title(['Field angle-angle, Waymark: ' num2str(waymarkIndex)])
ylabel('Field angle')
xlabel('Angle')

% Save the plot

if(PRINT_PLOT)
	filo = [experimentTagDir, experimentTagFig, '_freqFieldTrajFig']; 
	print(freqFieldTrajFig,'-depsc2',[filo, '.eps']);
	system(['pstopdf "', filo, '.eps" -o "', filo, '.pdf"']);
end


% Compute the impulse response of the waymark
% ===========================================

% 	freqRespWaymarkFig = figure('name', ['Frequency respose, Waymark:' num2str(waymarkIndex)]);
% 	subplot(2,1,1);
% 	plot(freqSearch, real(freqRespWaymarkA));
% 	title(['Frequency respose (Re), Waymark' num2str(waymarkIndex)])
% 	ylabel('Amplitude')
% 	xlabel('Frequency (Hz)')
% 
% 	subplot(2,1,2);
% 	plot(freqSearch, imag(freqRespWaymarkA));
% 	title(['Frequency respose Waymark (Im), Waymark' num2str(waymarkIndex)])
% 	ylabel('Amplitude')
% 	xlabel('Frequency (Hz)')
% 
% 	% Save the plot
% 	if(PRINT_PLOT)
% 		filo = [experimentTagDir, experimentTagFig, '_freqRespWaymarkFig']; 
% 		print(freqRespWaymarkFig,'-depsc2',[filo, '.eps']);
% 		system(['pstopdf "', filo, '.eps" -o "', filo, '.pdf"']);
% 	end
 

% % Waymark delay estimation
% % ========================
% 
% 	WAYMARK_ARR_NUM	= 15;
% 	waymarkDelay2DFig = figure('name',['Delay estimation (waymark ', num2str(WAYMARK_ARR_NUM), ')']);
% 	plot(deltaPoints(:, WAYMARK_ARR_NUM, 1), deltaPoints(:, WAYMARK_ARR_NUM, 2), 'g-+');
% 	title(['Delay estimation (waymark ', num2str(WAYMARK_ARR_NUM), ')'])
% 	ylabel('Estimation quality')
% 	xlabel('Delta delay')
% 
% 	% Save the plot
% 	if(PRINT_PLOT)
% 		filo = [experimentTagDir, experimentTagFig, '_waymarkDelay2DFig']; 
% 		print(waymarkDelay2DFig,'-depsc2',[filo, '.eps']);
% 		system(['pstopdf "', filo, '.eps" -o "', filo, '.pdf"']);
% 	end
% 
% 	waymarkDelay3DFig = figure('name', 'Delay estimation (all waymarks)');
% 	[waymarkSeries] = meshgrid (1:NUM_WAYMARKS, 1:deltaSize);
% 	plot3(deltaPoints(:, :, 1), waymarkSeries, deltaPoints(:, :, 2), 'g-+');
% 	grid on;
% 	view(26, 42);
% 	title('Delay estimation (all waymark)')
% 	xlabel('Delta delay')
% 	ylabel('Waymark')
% 	zlabel('Estimation quality')
% 
% 	% Save the plot
% 	if(PRINT_PLOT)
% 		filo = [experimentTagDir, experimentTagFig, '_waymarkDelay3DFig']; 
% 		print(waymarkDelay3DFig,'-depsc2',[filo, '.eps']);
% 		system(['pstopdf "', filo, '.eps" -o "', filo, '.pdf"']);
% 	end
% 
% 	delayAdjustFigure = figure('name', 'Delay adjustment Waymark');
% 	plot(delayAdjust(2:end));											% Ignore the first point as this is always zero and scales the plot badly
% 	title('Delay adjustment');
% 	ylabel('Delay (s)');
% 	xlabel('Waymark');
% 
% 	% Save the plot
% 	if(PRINT_PLOT)
% % 		filo = [experimentTagDir, experimentTagFig, '_delayAdjustFigure']; 
% % 		print(delayAdjustFigure,'-depsc2',[filo, '.eps']);
% % 		system(['pstopdf "', filo, '.eps" -o "', filo, '.pdf"']);
% 	end
% 
% 

% Signal downshift and decimate
% =============================
% Plot the test signal and the frequency shifted version
inputSignalFig = figure('name', ['Input Signal window Figure, Waymark: ' num2str(waymarkIndex)]);
subplot(5,1,1);
plot(timeIpSignal, inputSignalWin);
title(['Input Signal window Signal, Waymark: ' num2str(waymarkIndex)])
xlabel('Time (s)')
ylabel('Amplitude')

% Generate the frequency response 
inputSignalWinFft = fft(inputSignalWin);
subplot(5,1,2);
plot( 	0 : F_SAMPLE/size(inputSignalWin,2) : F_SAMPLE-F_SAMPLE/size(inputSignalWin,2), ...
			abs(inputSignalWinFft)/max(abs(inputSignalWinFft)), 'b' );
title(['Test Signal FFT, Waymark: ' num2str(waymarkIndex)])
xlabel('Freqency')
ylabel('Amplitude')
grid on;


% Generate the frequency response 
signalDShiftFft = fft(signalDShift);

subplot(5,1,3);
plot( 	0 : F_SAMPLE/size(signalDShift,2) : F_SAMPLE-F_SAMPLE/size(signalDShift,2), ...
			abs(signalDShiftFft)/max(abs(signalDShiftFft)), 'b' );
title(['Shifted Input Signal FFT, Waymark: ' num2str(waymarkIndex)])
xlabel('Freqency')
ylabel('Amplitude')
grid on;

subplot(5,1,4);
plot(real(signalDShift));
title(['Test Signal Re (zero padded), Waymark: ' num2str(waymarkIndex)])
xlabel('Samples')
ylabel('Amplitude')

subplot(5,1,5)
plot(imag(signalDShift));
title(['Test Signal Im (zero padded), Waymark: ' num2str(waymarkIndex)])
xlabel('Samples')
ylabel('Amplitude')

% Save the plot
if(PRINT_PLOT)
	filo = [experimentTagDir, experimentTagFig, '_testSignalFig']; 
	print(testSignalFig,'-depsc2',[filo, '.eps']);
	system(['pstopdf "', filo, '.eps" -o "', filo, '.pdf"']);
end




% % Plot the raised cosine filter
% %==============================
% 	timePlot = -T_SAMPLE*(floor(NUM_POINTS/2)) : T_SAMPLE : T_SAMPLE*(floor(NUM_POINTS/2));
% 	raisedCosFig = figure('name', ['Raised-cosine Figure alpha = ' num2str(ROLL_OFF)]);
% 	plot(timePlot*F_SYMBOL, raisedCos);
% 	title(['Raised-cosine alpha = ' num2str(ROLL_OFF)])
% 	xlabel('Time (symbol periods)')
% 	ylabel('Amplitude')
% 	grid on;
% 	% Save the plot
% 	if(PRINT_PLOT)
% 		filo = [experimentTagDir, experimentTagFig, '_raisedCosFig']; 
% 		print(raisedCosFig,'-depsc2',[filo, '.eps']);
% 		system(['pstopdf "', filo, '.eps" -o "', filo, '.pdf"']);
% 	end



% Plot the filtered and decimated signal
% ======================================
timeSignalDeci = (waymarkIndex-5)*T_WAYMARK : T_DECI_SAMPLE : ((waymarkIndex-0)*T_WAYMARK)-T_DECI_SAMPLE;
signalDeciFig = figure('name', ['Decimated Signal Figure (signalDeciBlock), Waymark: ' num2str(waymarkIndex)]);
subplot(3,1,1);
plot(timeSignalDeci, real(signalDeciBlock));
title(['Filter Signal (Re), Waymark: ' num2str(waymarkIndex)])
xlabel('Time (s)')
ylabel('Amplitude')
grid on;

subplot(3,1,2);
plot(timeSignalDeci, imag(signalDeciBlock));
title(['Filter Signal (Im), Waymark: ' num2str(waymarkIndex)])
xlabel('Time (s)')
ylabel('Amplitude')
grid on;

% Generate the frequency response 
signalDeciFft = fft(signalDeciBlock);
subplot(3,1,3);
plot( 	0 : F_DECI_SAMPLE/size(signalDeciBlock,2) : F_DECI_SAMPLE-F_DECI_SAMPLE/size(signalDeciBlock,2), ...
			abs(signalDeciFft)/max(abs(signalDeciFft)), 'b' );
title(['Filter Signal FFT, Waymark: ' num2str(waymarkIndex)])
xlabel('Freqency')
ylabel('Amplitude')
grid on;

% Save the plot
if(PRINT_PLOT)
	filo = [experimentTagDir, experimentTagFig, '_filterSignalFig']; 
	print(filterSignalFig,'-depsc2',[filo, '.eps']);
	system(['pstopdf "', filo, '.eps" -o "', filo, '.pdf"']);
end

% % Plot the filtered and decimated signal
% 	timeDelaySignalDeci = (waymarkIndex-3)*T_WAYMARK : T_DECI_SAMPLE : ((waymarkIndex+5)*T_WAYMARK)-T_DECI_SAMPLE;
% 	delaySignalDeciFig = figure('name', ['Decimated Delayed Signal Figure (signalDCompStore), Waymark: ' num2str(waymarkIndex)]);
% 	subplot(3,1,1);
% 	plot(timeDelaySignalDeci, real(signalDCompStore));
% 	title(['Delayed Filter Signal (Re), Waymark: ' num2str(waymarkIndex)])
% 	xlabel('Time (s)')
% 	ylabel('Amplitude')
% 	grid on;
% 
% 	subplot(3,1,2);
% 	plot(timeDelaySignalDeci, imag(signalDCompStore));
% 	title(['Delayed Filter Signal (Im), Waymark: ' num2str(waymarkIndex)])
% 	xlabel('Time (s)')
% 	ylabel('Amplitude')
% 	grid on;
% 
% 	% Generate the frequency response 
% 	delaySignalDeciFft = fft(signalDCompStore);
% 	subplot(3,1,3);
% 	plot( 	0 : F_DECI_SAMPLE/size(signalDCompStore,2) : F_DECI_SAMPLE-F_DECI_SAMPLE/size(signalDCompStore,2), ...
% 				abs(delaySignalDeciFft)/max(abs(delaySignalDeciFft)), 'b' );
% 	title(['Delayed Filter Signal FFT, Waymark: ' num2str(waymarkIndex)])
% 	xlabel('Freqency')
% 	ylabel('Amplitude')
% 	grid on;
% 
% 	% Save the plot
% 	if(PRINT_PLOT)
% % 		filo = [experimentTagDir, experimentTagFig, '_filterSignalFig']; 
% % 		print(filterSignalFig,'-depsc2',[filo, '.eps']);
% % 		system(['pstopdf "', filo, '.eps" -o "', filo, '.pdf"']);
% 	end 


% Waymark delays
% ==============
timeSignalDelay = (waymarkIndex-SINGLE_SPLINE_SUPPORT)*T_WAYMARK : T_SAMPLE : ((waymarkIndex-SINGLE_SPLINE_SUPPORT+1)*T_WAYMARK)-T_SAMPLE;

signalDelayDeciFig = figure('name', ['Sample rate delay Figure, Waymark: ' num2str(waymarkIndex)]);
plot(timeSignalDelay, signalDelayT0);
title(['Sample rate delay, Waymark: ' num2str(waymarkIndex)])
xlabel('Time (s)')
ylabel('Delay (s)')


% Wymark impulse response
% =======================
waymarkPlotFig = figure('name', ['Waymark spline support, Waymark: ' num2str(waymarkIndex)]);
plot(abs(impulseResp(:,1)), 'm');
hold on;
plot(abs(impulseResp(:,2)), 'c');
plot(abs(impulseResp(:,3)), 'r');
plot(abs(impulseResp(:,4)), 'k');
plot(abs(impulseResp(:,5)), 'g');
plot(abs(impulseResp(:,6)), 'y');
plot(abs(impulseRespInterp), 'b');
title(['Waymark spline support, Waymark: ' num2str(waymarkIndex)])
xlabel('Samples')
ylabel('Amplitude')


waymarkReImPlotFig = figure('name', ['Waymark spline support (Re - Im), Waymark: ' num2str(waymarkIndex)]);
subplot(2,1,1);
plot(real(impulseResp(:,1)), 'm');
hold on;
plot(real(impulseResp(:,2)), 'c');
plot(real(impulseResp(:,3)), 'r');
plot(real(impulseResp(:,4)), 'k');
plot(real(impulseResp(:,5)), 'g');
plot(real(impulseResp(:,6)), 'y');
plot(real(impulseRespInterp), 'b');
title(['Waymark spline support (Re), Waymark: ' num2str(waymarkIndex)])
xlabel('Samples')
ylabel('Amplitude')

subplot(2,1,2);
plot(imag(impulseResp(:,1)), 'm');
hold on;
plot(imag(impulseResp(:,2)), 'c');
plot(imag(impulseResp(:,3)), 'r');
plot(imag(impulseResp(:,4)), 'k');
plot(imag(impulseResp(:,5)), 'g');
plot(imag(impulseResp(:,6)), 'y');
plot(imag(impulseRespInterp), 'b');
title(['Waymark spline support (Im), Waymark: ' num2str(waymarkIndex)])
xlabel('Samples')
ylabel('Amplitude')



signalDelayT0BlockPlotFig = figure('name', ['signalDelayT0Block, Waymark: ' num2str(waymarkIndex)]);
plot(signalDelayT0Block);
title(['signalDelayT0Block, Waymark: ' num2str(waymarkIndex)])
xlabel('Samples')
ylabel('Amplitude')


% Final output signal
% ===================
interpSignalUShiftPlotFig = figure('name', ['interpSignalUShift, Waymark: ' num2str(waymarkIndex)]);
plot(interpSignalUShift);
title(['interpSignalUShift, Waymark: ' num2str(waymarkIndex)])
xlabel('Samples')
ylabel('Amplitude')

% Final output signal spectrum
% ============================
interpSignalUShiftFft = fft(interpSignalUShift);
% plot the whole range of the data
freqSpectrumFullFig = figure('name', 'Frequency spectrum (full)');
plot( 	0 : F_SAMPLE/size(interpSignalUShift,2) : F_SAMPLE-F_SAMPLE/size(interpSignalUShift,2), ...
			abs(interpSignalUShiftFft)/max(abs(interpSignalUShiftFft)), 'b-' );
title('Frequency spectrum (full)')
xlabel('Frequency (Hz)')
ylabel('Amplitude')
grid on;
% Save the plot
if(PRINT_PLOT)
	filo = [experimentTagDir, experimentTagFig, '_freqSpectrumFullFig']; 
	print(freqSpectrumFullFig,'-depsc2',[filo, '.eps']);
	system(['pstopdf "', filo, '.eps" -o "', filo, '.pdf"']);					
end


				START_FREQ	= 9965;
				STOP_FREQ	= 9978;
				START_TIME	= 10;
				STOP_TIME	= 90;
% 				SIGNAL_TIME	= size(interpSignalUShift,2)*T_SAMPLE;
% 				START_TIME	= SIGNAL_TIME*0.10;
% 				STOP_TIME	= SIGNAL_TIME*0.90;
				interpSignalUShiftWinFft = fft(interpSignalUShift(floor(START_TIME*F_SAMPLE) : floor(STOP_TIME*F_SAMPLE)));
				freqSpectrumFullFig = figure('name', ['Frequency spectrum (' num2str(START_TIME) 's to ' num2str(STOP_TIME) 's)']);
				plot( 	0 : F_SAMPLE/size(interpSignalUShift(floor(START_TIME*F_SAMPLE) : floor(STOP_TIME*F_SAMPLE)),2) : F_SAMPLE-F_SAMPLE/size(interpSignalUShift(floor(START_TIME*F_SAMPLE) : floor(STOP_TIME*F_SAMPLE)),2), ...
							abs(interpSignalUShiftWinFft)/max(abs(interpSignalUShiftWinFft)), 'b' );
				title(['Frequency spectrum (' num2str(START_TIME) 's to ' num2str(STOP_TIME) 's)'])
				xlabel('Frequency (Hz)')
				ylabel('Amplitude')
				axis([START_FREQ STOP_FREQ -0.1 1]);
				grid on;	
				% Save the plot
% 				if(PRINT_PLOT)
					filo = [experimentTagDir, experimentTagFig, '_freqSpectrumClipFig']; 
					print(freqSpectrumFullFig,'-depsc2',[filo, '.eps']);
					system(['pstopdf "', filo, '.eps" -o "', filo, '.pdf"']);					
% 				end
				

% Post channel
% ============

% Plot the interpolated signal	
interpSignalFig = figure('name', 'Post Channel Signal Figure');

subplot(5,1,1);
plot(real(signalChnlBlock));
title('Post channel Signal (Re)')
xlabel('Samples')
ylabel('Amplitude')

subplot(5,1,2);
plot(imag(signalChnlBlock));
title('Post channel Signal (Im)')
xlabel('Samples')
ylabel('Amplitude')			


subplot(5,1,3);
plot(real(interpSignalUp));
title('Interpolated Signal Re')
xlabel('Samples')
ylabel('Amplitude')

subplot(5,1,4);
plot(imag(interpSignalUp));
title('Interpolated Signal Im')
xlabel('Samples')
ylabel('Amplitude')

% Generate the frequency response 
interpSignalFft = fft(interpSignalUp);
subplot(5,1,5);
plot( 	0 : F_SAMPLE/size(interpSignalUp,2) : F_SAMPLE-F_SAMPLE/size(interpSignalUp,2), ...
			abs(interpSignalFft)/max(abs(interpSignalFft)), 'b' );
title('Interpolated Signal FFT')
xlabel('Freqency')
ylabel('Amplitude')
grid on;

% Save the plot
if(PRINT_PLOT)
	filo = [experimentTagDir, experimentTagFig, '_interpSignalFig']; 
	print(interpSignalFig,'-depsc2',[filo, '.eps']);
	system(['pstopdf "', filo, '.eps" -o "', filo, '.pdf"']);
end

 





% Plot the final upshifted signal
%	interpSignalUShiftFft = fft(interpSignalUShift);

% 	interpSignalUShiftFig = figure('name', 'Up Shifted Interpolated Post Channel Signal Figure');
% 	subplot(2,1,1);
% 	plot(timeIpSignal, interpSignalUShift);
% 	title('Up Shifted Interpolated Signal Signal')
% 	xlabel('Time (s)')
% 	ylabel('Amplitude')
% 
% 	subplot(2,1,2);
% 	plot( 	0 : F_SAMPLE/size(interpSignalUShift,2) : F_SAMPLE-F_SAMPLE/size(interpSignalUShift,2), ...
% 				abs(interpSignalUShiftFft)/max(abs(interpSignalUShiftFft)), 'b' );
% 	title('Up Shifted Interpolated Signal FFT')
% 	xlabel('Freqency')
% 	ylabel('Amplitude')
% 	grid on;
% 
% 	% Save the plot
% 	if(PRINT_PLOT)
% % 		filo = [experimentTagDir, experimentTagFig, '_interpSignalUShiftFig']; 
% % 		print(interpSignalUShiftFig,'-depsc2',[filo, '.eps']);
% % 		system(['pstopdf "', filo, '.eps" -o "', filo, '.pdf"']);
% 	end
% 











% % --------------------------------
% % Impulse response and spectrgrams
% % --------------------------------
% 
% 	WAYMARK_IMP_NUM	= 48;
% 	% Plot the area of interest
% 	impulseResponseFig = figure('name', ['Impulse response (Waymark ', num2str(WAYMARK_IMP_NUM), ' to ', num2str(WAYMARK_IMP_NUM+2), ')']);
% 	% First plot
% 	subplot(3,1,1);
% 	plot(timeChannel, real(impulseOR(:,WAYMARK_IMP_NUM))); % waymark impulse repsonse
% 	title(['Impulse response Re (Waymark ', num2str(WAYMARK_IMP_NUM), ')'])
% 	ylabel('Amplitude')
% 	xlabel('Delay (s)');
% 	hold on;
% 
% 	subplot(3,1,2);
% 	plot(timeChannel, imag(impulseOR(:,WAYMARK_IMP_NUM))); % waymark impulse repsonse
% 	title(['Impulse response Im (Waymark ', num2str(WAYMARK_IMP_NUM), ')'])
% 	ylabel('Amplitude')
% 	xlabel('Delay (s)');
% 	hold on;
% 
% 	subplot(3,1,3);
% 	plot(timeChannel, abs(impulseOR(:,WAYMARK_IMP_NUM))); % waymark impulse repsonse
% 	title(['Impulse response Abs (Waymark ', num2str(WAYMARK_IMP_NUM), ')'])
% 	ylabel('Amplitude')
% 	xlabel('Delay (s)');
% 	hold on;
% 
% 	% Second plot
% 	subplot(3,1,1);
% 	plot(timeChannel, real(impulseOR(:,WAYMARK_IMP_NUM+1)), 'g'); % waymark impulse repsonse
% 	title(['Impulse response Re (Waymark ', num2str(WAYMARK_IMP_NUM), ')'])
% 	ylabel('Amplitude')
% 	xlabel('Delay (sc)');
% 
% 	subplot(3,1,2);
% 	plot(timeChannel, imag(impulseOR(:,WAYMARK_IMP_NUM+1)), 'g'); % waymark impulse repsonse
% 	title(['Impulse response Im (Waymark ', num2str(WAYMARK_IMP_NUM), ')'])
% 	ylabel('Amplitude')
% 	xlabel('Delay (s)');
% 
% 	subplot(3,1,3);
% 	plot(timeChannel, abs(impulseOR(:,WAYMARK_IMP_NUM+1)), 'g'); % waymark impulse repsonse
% 	title(['Impulse response Abs (Waymark ', num2str(WAYMARK_IMP_NUM+1), ')'])
% 	ylabel('Amplitude')
% 	xlabel('Delay (s)');
% 
% 	% Third plot
% 	subplot(3,1,1);
% 	plot(timeChannel, real(impulseOR(:,WAYMARK_IMP_NUM+2)), 'r'); % waymark impulse repsonse
% 	title(['Impulse response Re (Waymark ', num2str(WAYMARK_IMP_NUM), ')'])
% 	ylabel('Amplitude')
% 	xlabel('Delay (s)');
% 	legend(num2str(WAYMARK_IMP_NUM), num2str(WAYMARK_IMP_NUM+1), num2str(WAYMARK_IMP_NUM+2));
% 	
% 	subplot(3,1,2);
% 	plot(timeChannel, imag(impulseOR(:,WAYMARK_IMP_NUM+2)), 'r'); % waymark impulse repsonse
% 	title(['Impulse response Im (Waymark ', num2str(WAYMARK_IMP_NUM), ')'])
% 	ylabel('Amplitude')
% 	xlabel('Delay (s)');
% 	legend(num2str(WAYMARK_IMP_NUM), num2str(WAYMARK_IMP_NUM+1), num2str(WAYMARK_IMP_NUM+2));
% 
% 	subplot(3,1,3);
% 	plot(timeChannel, abs(impulseOR(:,WAYMARK_IMP_NUM+2)), 'r'); % waymark impulse repsonse
% 	title(['Impulse response Abs (Waymark ', num2str(WAYMARK_IMP_NUM), ')'])
% 	ylabel('Amplitude')
% 	xlabel('Delay (s)');
% 	legend(num2str(WAYMARK_IMP_NUM), num2str(WAYMARK_IMP_NUM+1), num2str(WAYMARK_IMP_NUM+2));
% 
%  	% Save the plot
% 	if(PRINT_PLOT)
% 		filo = [experimentTagDir, experimentTagFig, '_impulseResponseFig']; 
% 		print(impulseResponseFig,'-depsc2',[filo, '.eps']);
% 		system(['pstopdf "', filo, '.eps" -o "', filo, '.pdf"']);
% 	end
% 	
% 
% 	
% 	
% 	
% 	WAYMARK_IMP_NUM	= 48;
% 	START_DELAY = -0.1;
% 	STOP_DELAY = 0.3;
% 	% Plot the area of interest
% 	impulseResponseAbsFig = figure('name', ['Impulse response Abs (Waymark ', num2str(WAYMARK_IMP_NUM), ' to ', num2str(WAYMARK_IMP_NUM+2), ')']);
% 
% 	plot(timeChannel, abs(impulseOR(:,WAYMARK_IMP_NUM))); % waymark impulse repsonse
% 	title(['Impulse response Abs (Waymark ', num2str(WAYMARK_IMP_NUM), ' to ', num2str(WAYMARK_IMP_NUM+2), ')'])
% 	ylabel('Amplitude')
% 	xlabel('Delay (s)');
% 	hold on;
% 
% 	plot(timeChannel, abs(impulseOR(:,WAYMARK_IMP_NUM+1)), 'g'); % waymark impulse repsonse
% 	plot(timeChannel, abs(impulseOR(:,WAYMARK_IMP_NUM+2)), 'r'); % waymark impulse repsonse
% 	legend(num2str(WAYMARK_IMP_NUM), num2str(WAYMARK_IMP_NUM+1), num2str(WAYMARK_IMP_NUM+2));
% 
% 	xlim([START_DELAY STOP_DELAY]);
%  	% Save the plot
% 	if(PRINT_PLOT)
% 		filo = [experimentTagDir, experimentTagFig, '_impulseResponseAbsFig']; 
% 		print(impulseResponseAbsFig,'-depsc2',[filo, '.eps']);
% 		system(['pstopdf "', filo, '.eps" -o "', filo, '.pdf"']);
% 	end
% 	
% 	% Plot the same impulse responses but with the delays added
% 	impulseResponseAbsDelaysFig = figure('name', ['Impulse response Abs Delays(Waymark ', num2str(WAYMARK_IMP_NUM), ' to ', num2str(WAYMARK_IMP_NUM+2), ')']);
% 
% 	plot((timeChannel + delayComp(WAYMARK_IMP_NUM)), abs(impulseOR(:,WAYMARK_IMP_NUM))); % waymark impulse repsonse
% 	title(['Impulse response Abs with delays (Waymark ', num2str(WAYMARK_IMP_NUM), ' to ', num2str(WAYMARK_IMP_NUM+2), ')'])
% 	ylabel('Amplitude')
% 	xlabel('Delay (s)');
% 	hold on;
% 
% 	plot((timeChannel + delayComp(WAYMARK_IMP_NUM+1)), abs(impulseOR(:,WAYMARK_IMP_NUM+1)), 'g'); % waymark impulse repsonse
% 	plot((timeChannel + delayComp(WAYMARK_IMP_NUM+2)), abs(impulseOR(:,WAYMARK_IMP_NUM+2)), 'r'); % waymark impulse repsonse
% 	legend(num2str(WAYMARK_IMP_NUM), num2str(WAYMARK_IMP_NUM+1), num2str(WAYMARK_IMP_NUM+2));
% 
% 	xlim([(START_DELAY + delayComp(WAYMARK_IMP_NUM)) (STOP_DELAY + delayComp(WAYMARK_IMP_NUM))]);
%  	% Save the plot
% 	if(PRINT_PLOT)
% 		filo = [experimentTagDir, experimentTagFig, '_impulseResponseAbsDelaysFig']; 
% 		print(impulseResponseAbsDelaysFig,'-depsc2',[filo, '.eps']);
% 		system(['pstopdf "', filo, '.eps" -o "', filo, '.pdf"']);
% 	end	
% 	
% 	
% 	
% 	
% 	
% 	
% 	
% 	WAYMARK_IMP_NUM	= 49;
% 	% Plot the interpolated delay.	
% 	delayCompInterpFig = figure('name', ['Interpolated Delay Compensation (all samples)']);
% 	plot(delayCompInterpUpshift);
% 	hold on;
% 	plot(WAYMARK_IMP_NUM*T_WAYMARK*F_SAMPLE, delayCompInterpUpshift(WAYMARK_IMP_NUM*T_WAYMARK*F_SAMPLE), 'ko');
% 	title(['Interpolated Delay Compensation (all samples)']);
% 	ylabel('Delay (s)')
% 	xlabel('Output sample');
% 
%  	% Save the plot
% 	if(PRINT_PLOT)
% 		filo = [experimentTagDir, experimentTagFig, '_delayCompInterpFig']; 
% 		print(delayCompInterpFig,'-depsc2',[filo, '.eps']);
% 		system(['pstopdf "', filo, '.eps" -o "', filo, '.pdf"']);
% 	end	
% 	
% 	
% 	
% 	
% 	
% 	

	


% 	START_FREQ	= 9965;
% 	STOP_FREQ	= 9976;
% 	START_TIME	= 2;
% 	STOP_TIME	= 8;
% % 	START_TIME	= 0.20;
% % 	STOP_TIME	= 0.80;
% 	interpSignalUShiftWinFft = fft(interpSignalUShift(floor(START_TIME*F_SAMPLE) : floor(STOP_TIME*F_SAMPLE)));
% 	freqSpectrumWinFig = figure('name', ['Frequency spectrum (' num2str(START_TIME) 's to ' num2str(STOP_TIME) 's)']);
% % 	plot( 	0 : F_SAMPLE/size(interpSignalUShift(floor(START_TIME*F_SAMPLE) : floor(STOP_TIME*F_SAMPLE)),2) : F_SAMPLE-F_SAMPLE/size(interpSignalUShift(floor(START_TIME*F_SAMPLE) : floor(STOP_TIME*F_SAMPLE)),2), ...
% % 				abs(interpSignalUShiftWinFft)/max(abs(interpSignalUShiftWinFft)), 'b' );
% 	plot( 	0 : F_SAMPLE/size(interpSignalUShift(floor(START_TIME*F_SAMPLE) : floor(STOP_TIME*F_SAMPLE)),2) : F_SAMPLE-F_SAMPLE/size(interpSignalUShift(floor(START_TIME*F_SAMPLE) : floor(STOP_TIME*F_SAMPLE)),2), ...
% 				abs(interpSignalUShiftWinFft), 'b' );
% 	title(['Frequency spectrum (' num2str(START_TIME) 's to ' num2str(STOP_TIME) 's)'])
% 	xlabel('Frequency (Hz)')
% 	ylabel('Amplitude')
% % 	axis([START_FREQ STOP_FREQ -0.1 1]);
% 	xlim([START_FREQ STOP_FREQ]);
% 	grid on;	
% 	% Save the plot
% 	if(PRINT_PLOT)
% 		filo = [experimentTagDir, experimentTagFig, '_freqSpectrumWinFig']; 
% 		print(freqSpectrumWinFig,'-depsc2',[filo, '.eps']);
% 		system(['pstopdf "', filo, '.eps" -o "', filo, '.pdf"']);					
% 	end
% 
% 	START_FREQ	= 0;
% 	STOP_FREQ	= 40000;
% 	START_TIME	= 2;
% 	STOP_TIME	= 8;
% % 	START_TIME	= 0.20;
% % 	STOP_TIME	= 0.80;
% 	interpSignalUShiftWinFft = fft(interpSignalUShift(floor(START_TIME*F_SAMPLE) : floor(STOP_TIME*F_SAMPLE)));
% 	freqSpectrumFullFig = figure('name', ['Frequency spectrum (' num2str(START_TIME) 's to ' num2str(STOP_TIME) 's)']);
%  	plot( 	0 : F_SAMPLE/size(interpSignalUShift(floor(START_TIME*F_SAMPLE) : floor(STOP_TIME*F_SAMPLE)),2) : F_SAMPLE-F_SAMPLE/size(interpSignalUShift(floor(START_TIME*F_SAMPLE) : floor(STOP_TIME*F_SAMPLE)),2), ...
%  				abs(interpSignalUShiftWinFft)/max(abs(interpSignalUShiftWinFft)), 'b' );
% % 	plot( 	0 : F_SAMPLE/size(interpSignalUShift(floor(START_TIME*F_SAMPLE) : floor(STOP_TIME*F_SAMPLE)),2) : F_SAMPLE-F_SAMPLE/size(interpSignalUShift(floor(START_TIME*F_SAMPLE) : floor(STOP_TIME*F_SAMPLE)),2), ...
% % 				abs(interpSignalUShiftWinFft), 'b' );
% 	title(['Frequency spectrum (' num2str(START_TIME) 's to ' num2str(STOP_TIME) 's)'])
% 	xlabel('Frequency (Hz)')
% 	ylabel('Amplitude')
% 	axis([START_FREQ STOP_FREQ -0.1 1]);
% 	grid on;	
% 	% Save the plot
% 	if(PRINT_PLOT)
% 		filo = [experimentTagDir, experimentTagFig, '_freqSpectrumFullFig']; 
% 		print(freqSpectrumFullFig,'-depsc2',[filo, '.eps']);
% 		system(['pstopdf "', filo, '.eps" -o "', filo, '.pdf"']);					
% 	end
% 	
%  	% plot the whole range of the data
% 	freqSpectrumFullFig = figure('name', 'Frequency spectrum (full)');
% 	plot( 	0 : F_SAMPLE/size(interpSignalUShift,2) : F_SAMPLE-F_SAMPLE/size(interpSignalUShift,2), ...
% 				abs(interpSignalUShiftFft)/max(abs(interpSignalUShiftFft)), 'b-' );
% 	title('Frequency spectrum (full)')
% 	xlabel('Frequency (Hz)')
% 	ylabel('Amplitude')
% 	grid on;
% 	% Save the plot
% 	if(PRINT_PLOT)
% 		filo = [experimentTagDir, experimentTagFig, '_freqSpectrumFullFig']; 
% 		print(freqSpectrumFullFig,'-depsc2',[filo, '.eps']);
% 		system(['pstopdf "', filo, '.eps" -o "', filo, '.pdf"']);					
% 	end
% 
% 
% 	freqSpectrumFig = figure('name', 'Frequency spectrum ');
% 	plot( 	0 : F_SAMPLE/size(interpSignalUShift,2) : F_SAMPLE-F_SAMPLE/size(interpSignalUShift,2), ...
% 				abs(interpSignalUShiftFft)/max(abs(interpSignalUShiftFft)), 'b-' );
% 	title('Frequency spectrum')
% 	xlabel('Frequency (Hz)')
% 	ylabel('Amplitude')
% 	axis([START_FREQ STOP_FREQ -0.1 1]);
% 	grid on;
% 	% Save the plot
% 	if(PRINT_PLOT)
% 		filo = [experimentTagDir, experimentTagFig, '_freqSpectrumFig']; 
% 		print(freqSpectrumFig,'-depsc2',[filo, '.eps']);
% 		system(['pstopdf "', filo, '.eps" -o "', filo, '.pdf"']);					
% 	end

											% 	spectrogramFullFig = figure('name', 'Spectrogram (full)');
											% 	WINDOW_SIZE		= 8192;
											% 	OVERLAP_SIZE	= 7680;
											% 	FFT_SIZE			= 16384;
											% 	spectrogram(interpSignalUShift, WINDOW_SIZE, OVERLAP_SIZE, FFT_SIZE, F_SAMPLE);
											% 	title('Spectrogram (full)')
											% 	set(gca, 'Fontweight', 'bold');
											% 	set(gca, 'Tickdir', 'out');
											% 	colorbar();
											% 	% Save the plot
											% 	if(PRINT_PLOT)
											% % 		filo = [experimentTagDir, experimentTagFig, '_spectrogramFullFig']; 
											% % 		print(spectrogramFullFig,'-depsc2',[filo, '.eps']);
											% % 		system(['pstopdf "', filo, '.eps" -o "', filo, '.pdf"']);
											% 	end
											% 
											% 	spectrogramFig = figure('name', 'Spectrogram');
											% 	WINDOW_SIZE		= 8192;
											% 	OVERLAP_SIZE	= 7680;
											% 	FFT_SIZE			= 16384;
											% 	spectrogram(interpSignalUShift, WINDOW_SIZE, OVERLAP_SIZE, FFT_SIZE, F_SAMPLE);
											% 	title('Spectrogram')
											% 	set(gca, 'XLim', [9000 11000]);
											% 	set(gca, 'Fontweight', 'bold');
											% 	set(gca, 'Tickdir', 'out');
											% 	colorbar();
											% 	% Save the plot
											% 	if(PRINT_PLOT)
											% 		filo = [experimentTagDir, experimentTagFig, '_spectrogramFig']; 
											% 		print(spectrogramFig,'-depsc2',[filo, '.eps']);
											% 		system(['pstopdf "', filo, '.eps" -o "', filo, '.pdf"']);
											% 	end

