function [field] = waymarkFieldGenBellhop(rxTxTraj, ENV_FILENAME, surface)
% Function to run BELLHOP and read the generated arrivals.
MAX_ARRIVALS = 1000;

% Write the BELLHOP altimetry for this frame
% Remove the old file
if exist([ENV_FILENAME, '.ati'], 'file')==2
  delete([ENV_FILENAME, '.ati']);
end


fid = fopen([ENV_FILENAME, '.ati'],'w');
fprintf(fid,'%s\n', '''C''');
fprintf(fid,'%i\n', length(surface.surfR));
for irange = 1:length(surface.surfR),
 % Note that altimetry files specify the depth, (or -1 * surface height)
 fprintf(fid,'%.8f %.8f\n', 0.001*surface.surfR(irange), -surface.surfH(irange));
end;
fclose(fid);


editBellhopEnvFile(rxTxTraj.rxDepth, rxTxTraj.txDepth, rxTxTraj.rxTxRange/1000, [ENV_FILENAME, '.env']);	% Adjust the environmental file according to the trajectory, required for every waymark (Range should be set in km).

bellhop(ENV_FILENAME);										% Call Bellhop to calculate the ray tracing, passing the modified environment file
[Arr, ~]= read_arrivals_asc([ENV_FILENAME, '.arr'], MAX_ARRIVALS);	% Read delay-arrival file

iN = find(Arr.delay);										% Find the indexes of the non-zero arrivals

if (length(iN) > MAX_ARRIVALS)
	disp(['Num arrivals exceeds MAX_ARRIVALS', num2str(length(iN))]);
	iN(MAX_ARRIVALS:end) = [];
end

field.delay(1:length(iN))		= Arr.delay(iN);		% Record the delay
field.amp(1:length(iN))			= Arr.A(iN);			% and the amplitude
field.srcAngle(1:length(iN))	= Arr.SrcAngle(iN);	% and the tx angle

