function editBellhopEnvFile(rxDepth, txDepth, rxTxRange, filename)
% This function makes changes to the .env file that is an input to the Bellhop model.
% Specifically the the things that may be altered are the
% frequency of interest, the receiver depth and the transmitter depth.
% Where:
%	rxDepth,		receiver depth
%	txDepth,		transmitter depth
%	rxTxRange,	range between the transmitter and reciever
%	filename,	file name of the .env file that is the input to Bellhop.

if ~exist(filename, 'file')		% Check that the file exsists and if not give error.
	error('Can''t find environment file specified');
end

[fid errmsg] = fopen(filename, 'r+');		% open file, 'r+' permission to write to.
if (errmsg ~=0)
	error('Can''t open environment file specified');
end

temp = fgetl(fid);
temp = fgetl(fid);
temp = fgetl(fid);
temp = fgetl(fid);
while ( fid~=-1 && (temp(2)~='A' && temp(2)~='F'))
    temp = fgetl(fid);
end
if (temp(2)=='A')
	temp = fgetl(fid);
end
temp = fgetl(fid);
fseek(fid,0,'cof');
fprintf(fid,'%6.2f /',txDepth);

temp = fgetl(fid);
temp = fgetl(fid);
fseek(fid,0,'cof');
fprintf(fid,'%6.2f /',rxDepth);

temp = fgetl(fid);
temp = fgetl(fid);
fseek(fid,0,'cof');
fprintf(fid,'%7.9f /',rxTxRange);


[errmsg] = fclose(fid);
if (errmsg ~=0)
	error('Can''t close the environment file specified');
end