function [ interpData ] = signalBSpline( inputData, inputWeights, interpPoint )
% SIGNALBSPLINE Function generates a local spline interpolated value at a point
% inputData, array of the local data to interpolate from.
% inputDataWeights, array of the weights for the input data (lengths must match)
% interpPoint, this is the interpolation point between the centre two values, expressed as a decimal.

	inputWeightsLen	= size(inputWeights, 2);

	% Do some basic checks on the data.
	if inputWeightsLen*2 ~= size(inputData,2)
		error('The data length must be twice as long than the data weight length');
	end

	if (interpPoint > 1) or (interpPoint <0)
		error('Interpotation point is outside input data range');
	end

	% Setup the bspline piecewise polynomial
	t = -ceil(inputWeightsLen/2):ceil(inputWeightsLen/2);
	pp = bspline(t);

	interpData = 0;
	% Step through each of the input data points generating the spline, weighting it by the spline weights and then the data value.
	for i = 1:inputWeightsLen+1															% +1 to evaluate all of the splines
		interpData	=	interpData + ...
							inputData(i:(i-1+inputWeightsLen))*inputWeights'...
							*fnval(pp,-ceil(inputWeightsLen/2)+(i-interpPoint));	% Generate the B-Spline by evaluating the piecewise polynomial function
	end

end

