		% ==============================================
		% Single speed of sound, flat surface experiment
		% ==============================================
		clear all;
		close all;

		% Generate the path to the Acoustic toolkit
		% UNIX path
		% The next line might be needed if you are a Mac user
		% setenv('DYLD_LIBRARY_PATH', '/usr/local/bin:/opt/local/lib:')
		path(path,genpath('~/Documents/MATLAB/at'));
		path(path,genpath('./'));

		EXPERIMENT_NUM				= 1;
		EXPERIMENT_NAME			= ['exp', num2str(EXPERIMENT_NUM), 'Waymark200Flat'];
		
		SRC_DATA.waveformName	= 'cw_10kHz_100s';
		SRC_DATA.waveformExt		= 'wav';
		SRC_DATA.fCarrier			= 10000;
		SRC_DATA.fSample			= 40000;
		SRC_DATA.bandwidth		= 2*156.25;
		
		SURFACE_PARAM.range			= 10000.0;
		SURFACE_PARAM.numRangePts	= 512;
		SURFACE_FUNCTION				= @surfaceGenFlat;
		
		TRAJECTORY_FUNCTION			= @waymarkTrajGenBellhopFunc200;
		
		ENVIRONMENT_FILE_NAME		= 'iso200';
		
		MISC.c0							= 1500;	% Maximum speed of sound (m/s)
		MISC.RXTX_SPEED_MAX			= 6;		% Maximum receiver/transmitter speed (m/s)
		MISC.ROLL_OFF					= 0.25;	% Roll off factor for the low pass filter.

		SIMULATION_TIME	= 120;
		T_WAYMARK			= 0.0512;			% Set the waymark interval (s)
		waymarkModelMain(EXPERIMENT_NAME, SRC_DATA, ENVIRONMENT_FILE_NAME, TRAJECTORY_FUNCTION, SURFACE_PARAM, SURFACE_FUNCTION, SIMULATION_TIME, T_WAYMARK, MISC);
 
 

 
 
% 			% ====================================================
% 			% Single speed of sound, sinusoidal surface experiment
% 			% ==================================================== 
% 			clear all;
% 			close all;
% 
% 
% 			% UNIX path
% 			path(path,genpath('~/Documents/MATLAB/at'));
% 			path(path,genpath('./'));
% 
% 
% 			EXPERIMENT_NUM		= 2;
% 			EXPERIMENT_NAME	= ['exp', num2str(EXPERIMENT_NUM), 'Waymark200Sine'];
% 			
% 			SRC_DATA.waveformName	= 'cw_10kHz_100s';
% 			SRC_DATA.waveformExt		= 'wav';
% 			SRC_DATA.fCarrier			= 10000;
% 			SRC_DATA.fSample			= 40000;
% 			SRC_DATA.bandwidth		= 2*156.25;
% 		
% 			SURFACE_PARAM.range			= 10000.0;
% 			SURFACE_PARAM.numRangePts	= 5120;
% 			SURFACE_FUNCTION				= @surfaceGenSine;
% 
% 			TRAJECTORY_FUNCTION			= @waymarkTrajGenBellhopFunc200;
% 
% 			ENVIRONMENT_FILE_NAME		= 'iso200';
% 		
%			MISC.c0							= 1500;	% Maximum speed of sound (m/s)
%			MISC.RXTX_SPEED_MAX			= 6;		% Maximum receiver/transmitter speed (m/s)
% 
% 			SIMULATION_TIME	= 120;
% 			T_WAYMARK			= 0.0512;					% Set the waymark interval (s)
% 			waymarkModelMain(EXPERIMENT_NAME, SRC_DATA, ENVIRONMENT_FILE_NAME, TRAJECTORY_FUNCTION, SURFACE_PARAM, SURFACE_FUNCTION, SIMULATION_TIME, T_WAYMARK< MISC);
% 
% 
% 
% 
% 
% 			% ====================================
% 			% SWellEx SSP, flat surface experiment
% 			% ====================================
% 			clear all;
% 			close all;
% 
% 
% 			% UNIX path
% 			path(path,genpath('~/Documents/MATLAB/at'));
% 			path(path,genpath('./'));
% 
% 
% 			EXPERIMENT_NUM		= 3;
% 			EXPERIMENT_NAME	= ['exp', num2str(EXPERIMENT_NUM), 'WaymarkSwellFlat'];
% 			
% 			SRC_DATA.waveformName	= 'cw_10kHz_100s';
% 			SRC_DATA.waveformExt		= 'wav';
% 			SRC_DATA.fCarrier			= 10000;
% 			SRC_DATA.fSample			= 40000;
% 			SRC_DATA.bandwidth		= 2*156.25;
% 
% 			SURFACE_PARAM.range			= 10000.0;
% 			SURFACE_PARAM.numRangePts	= 512;
% 			SURFACE_FUNCTION				= @surfaceGenFlat;
% 
% 			TRAJECTORY_FUNCTION			= @waymarkTrajGenSwellex;
% 
% 			ENVIRONMENT_FILE_NAME		= 'SWellExS5';
% 		
%			MISC.c0							= 1500;	% Maximum speed of sound (m/s)
%			MISC.RXTX_SPEED_MAX			= 6;		% Maximum receiver/transmitter speed (m/s)
% 
% 			SIMULATION_TIME	= 120;
% 			T_WAYMARK			= 0.0512;					% Set the waymark interval (s)
% 			% bounce( 'SWellExS5_tabCoeff' )   % make the tabulated reflection coefficient
% 			% copyfile( 'SWellExS5_tabCoeff.brc', 'SWellExS5.brc' )
% 			waymarkModelMain(EXPERIMENT_NAME, SRC_DATA, ENVIRONMENT_FILE_NAME, TRAJECTORY_FUNCTION, SURFACE_PARAM, SURFACE_FUNCTION, SIMULATION_TIME, T_WAYMARK, MISC);
%  
% 
% 
% 
% 
% 			% ==========================================
% 			% SWellEx SSP, sinusoidal surface experiment
% 			% ========================================== 
% 			clear all;
% 			close all;
% 
% 
% 			% UNIX path
% 			path(path,genpath('~/Documents/MATLAB/at'));
% 			path(path,genpath('./'));
% 
% 
% 			EXPERIMENT_NUM		= 4;
% 			EXPERIMENT_NAME	= ['exp', num2str(EXPERIMENT_NUM), 'WaymarkSwellSine'];
% 			
% 			SRC_DATA.waveformName	= 'cw_10kHz_100s';
% 			SRC_DATA.waveformExt		= 'wav';
% 			SRC_DATA.fCarrier			= 10000;
% 			SRC_DATA.fSample			= 40000;
% 			SRC_DATA.bandwidth		= 2*156.25;
% 
% 			SURFACE_PARAM.range			= 10000.0;
% 			SURFACE_PARAM.numRangePts	= 5120;
% 			SURFACE_FUNCTION				= @surfaceGenSine;
% 
% 			TRAJECTORY_FUNCTION			= @waymarkTrajGenSwellex;
% 
% 			ENVIRONMENT_FILE_NAME		= 'SWellExS5';
% 		
%			MISC.c0							= 1500;	% Maximum speed of sound (m/s)
%			MISC.RXTX_SPEED_MAX			= 6;		% Maximum receiver/transmitter speed (m/s)
% 
% 			SIMULATION_TIME	= 120;
% 			T_WAYMARK			= 0.0512;					% Set the waymark interval (s)
% 			% bounce( 'SWellExS5_tabCoeff' )		% make the tabulated reflection coefficient
% 			% copyfile( 'SWellExS5_tabCoeff.brc', 'SWellExS5.brc' )
% 			waymarkModelMain(EXPERIMENT_NAME, SRC_DATA, ENVIRONMENT_FILE_NAME, TRAJECTORY_FUNCTION, SURFACE_PARAM, SURFACE_FUNCTION, SIMULATION_TIME, T_WAYMARK, MISC);

