function [surface] = surfaceGenSine(time, SURFACE_PARAM)
% Function to generate a sinusoidal surface

% References
% ==========
% [1] J. Peterson and M. Porter, "Ray/Beam Tracing for Modeling the Effects of Ocean and Platform Dynamics," IEEE Journal of Oceanic Engineering, vol. 38, no. 4, pp. 655-665, 2013.

% Surface generation based on code from the VirTEX model by Michael Porter [1].

% Where:
%		time, is the point in time that the surface is generated for
%		SURFACE_PARAM.range				% The extent of the surface description
%		SURFACE_PARAM.numRangePts		% The number of surface range points in the field calculation

%		surface.surfR, range points
%		surface.surfT, time array
%		surface.surfH, height of the surface at range and time points

swellAmp			= 5.0;	% caution: not the same as significant wave height
swellPeriod		= 8.0;
surface.surfR	= SURFACE_PARAM.range*(0:SURFACE_PARAM.numRangePts-1)/(SURFACE_PARAM.numRangePts-1);
surface.surfT	= time;
surface.surfH	= zeros(SURFACE_PARAM.numRangePts, 1);

grav	= 9.81;
omega	= 2.0*pi/swellPeriod;
k = omega^2 / grav;

for j = 1:SURFACE_PARAM.numRangePts,
  % generate a simple swell wave
  surface.surfH(j) = swellAmp * sin(omega*surface.surfT - k*surface.surfR(j));
end;
