function [surface] = surfaceGenFlat(time, SURFACE_PARAM)
% Function to generate a flat surface
% Where:
%		time, is the point in time that the surface is generated for
%		SURFACE_PARAM.range				% The extent of the surface description
%		SURFACE_PARAM.numRangePts		% The number of surface range points in the field calculation

%		surface.surfR, range points
%		surface.surfT, time array
%		surface.surfH, height of the surface at range and time points

numRangePts		= SURFACE_PARAM.numRangePts;
surface.surfR	= SURFACE_PARAM.range*(0:numRangePts-1)/(numRangePts-1);
surface.surfT	= time;
surface.surfH	= zeros(numRangePts, 1);