% A script to generate a test signal and save it as a .wav file

% Signal parameters
T_SIGNAL		= 5;						% Signal duration (s)
F_SAMPLE		= 40000;					% Signal sampling frequency (Hz)
T_SAMPLE		= 1/F_SAMPLE;			% Signal sample period (s)
N_BITS		= 32;						% The bit depth for each sample

% Sine wave generator
A_TEST_SIGNAL	= 1;					% Test sinusiod amplitude
F_TEST_SIGNAL	= 10000;				% Test sinusoid frequency (Hz)

time = 0 : T_SAMPLE : T_SIGNAL-T_SAMPLE;	% Generate the time steps for the signal,
														% -T_SAMPLE to give an even number of samples, starting at 0 time.
 testSignal = A_TEST_SIGNAL * sin(2 * pi() * F_TEST_SIGNAL * time);
% testSignal = [1 zeros(1, size(time, 2)-1)];		% Single sample test signal to test the timing through the system.

testSignalFig = figure('name', 'Test Signal Figure');
plot(time, testSignal);

% Save the waveform with a sensible filename
audiowrite(['cw_' num2str(F_TEST_SIGNAL/1000) 'kHz_' num2str(T_SIGNAL) 's.wav'], testSignal, F_SAMPLE, 'BitsPerSample', N_BITS);