#!/usr/bin/python

import random
import sympy
import time
from SimpleXMLRPCServer import SimpleXMLRPCServer

##### Server functions ##############################################################################################
def GetDefault():
    return Default

def getID(clname):
    global legend
    global cl_list
    if clname not in cl_list:
        cl_list.append(clname)
    else:
        print 'client at PC %s bounced back - clicked twice'%clname
        return None
    if ID_group:
        ID, group = ID_group.pop(0)
        print 'Client %s, of group %s, connected; sits at PC %s - %s'%(ID,  group, clname, N-len(ID_group))
        legend.append([group, ID, clname, dictators[group-1], payperiods[group-1]])
        if not ID_group:
            print 'All clients connected. Ready to go.'
            f = open('legend.csv', 'a')
            for row in legend:
                print >> f, row[0],',',row[1],',',row[2],',',row[3],',',row[4]
            f.close()
            print '\n-----------------------------------------\nSession details written to legend.csv\n'
        return (ID, group)
    else: return None


def RegisterChoice(ID, group, choices):
    """Stores the ID, group and choice of subjects; when all choices submitted, unblocks token"""
    global ChoiceFull
    ChoiceList.append([ID, group, choices])
    print 'Client %s of society %s has terminated part 1. - %s'%(ID, group, len(ChoiceList))
    if len(ChoiceList)==N:                          #all have chosen: updating file so that clients can see it
        ChoiceFull = True
        
        tx = open('Output/firstchoice','wb')
        tx.write(str(time.ctime()))
        tx.close()
        
        print '-----------------------------------'
        if Treatment == 'int':
            print 'All clients have terminated part 1 \nDrawing the dictators'
            print 'Dictators are        :',  dictators
            print 'Pay Scenarios are    :',  payperiods
        else:
            print 'All clients have terminated part 1 \nApplying the dictators choice'
        finalchoiceout = open('Output/finalchoice.out', 'w')
        #generating final choices file
        print >> finalchoiceout,  'ID, group, Sc2a, Sc2b, Sc1a, Sc1b, Sc3, drop'
        for item in ChoiceList:
            print >> finalchoiceout, '%s,%s,%s,%s,%s,%s,%s,%s'%(item[0], item[1], item[2][0], item[2][1], item[2][2], item[2][3], item[2][4][0], item[2][4][1])
        finalchoiceout.close()
        print '------ final choices written to finalchoice.out ------'
    return None

def DrawDictators():
    """Draws for each group a dictator. Treatments"""
    global dictators
    if Treatment == 'int':
        for i in range(N/4):
            dictators.append(random.choice(range(1, 5)))
    if Treatment == 'ext':
        for i in range(N/5):
            dictators.append(5)
    return None

def DrawPayPeriods():
    global payperiods
    if Treatment == 'int':
        for i in range(N/4):
            payperiods.append(ScenarioChoice())
    if Treatment == 'ext':
        for i in range(N/5):
            payperiods.append(ScenarioChoice())
    return None

def ScenarioChoice():
    w = [0.125,0.125,0.125,0.125,0.5]
    rnd = random.random() * sum(w)
    for i, w in enumerate(w):
        rnd -= w
        if rnd < 0:
            return i+1

def getDictator(group):
    thedict = dictators[group-1]
    choice = 0
    for item in ChoiceList:
        if item[1]==group:
            if item[0]==thedict:
                choice=item[2]
    if not choice:
        choice = [0, 0, 0, 0]
    return (thedict, choice)

def getPayPeriod(group):
    return payperiods[group-1]

def getFinalData(group):
    global playatpos
    return playatpos[group-1]

def RegisterFinal(ID, group, luck, stay):
    global FinalList
    global solList
    global playatpos
    global posList
    global dictators
    global positions
    #notification
    if ID != 5:
        if luck == 0:
            detail1 = 'has BAD luck'
        if luck == 1:
            detail1 = 'has GOOD luck'
        if stay == 0:
            detail2 = 'and chose to LEAVE for part 2'
        if stay == 1:
            detail2 = 'and chose to STAY for part 2'
        if stay == 100:
            detail2 = 'stay choice not defined'
        if stay != 0 and stay != 1 and stay != 100:
            detail2 = 'stay choice is %s'%(stay)
        print 'client', ID,  'of society',  group,  detail1,  detail2
        
        if luck == 0 and stay == 0: cell = 'A'
        if luck == 0 and stay == 1: cell = 'B'
        if luck == 1 and stay == 0: cell = 'C'
        if luck == 1 and stay == 1: cell = 'D'
        
    if ID == 5:
        cell = None
        
    FinalList.append([ID, group, cell])
    try: print len(FinalList)
    except: pass
    
    if len(FinalList)==N:
        safe1 = open('Output/safe.out', 'a')
        print >> safe1,  ID,',',group,',',cell
        for row in FinalList:
            print >> safe1, row[0],',',row[1],',',row[2]
        safe1.close()
        print '-----------------------------\nAll players have finished their choices.\n\nComputing the final solution...'
        
        playatpos = []
        if Treatment == 'int':
            grouprange = range(1, N/4+1)
        if Treatment == 'ext':
            grouprange = range(1, N/5+1)
        
        for gr in grouprange:
            positions = [[],[],[],[]] #at1,at2,at3,at4
            for item in FinalList:
                if item[1]==gr:
                    if item[2]=='A': positions[0].append(item[0])
                    if item[2]=='B': positions[1].append(item[0])
                    if item[2]=='C': positions[2].append(item[0])
                    if item[2]=='D': positions[3].append(item[0])
            playatpos.append(positions)
            
        #printing to file
        tx = open('Output/secondchoice','wb')
        tx.write(str(time.ctime()))
        tx.close()
        return None

def Dummy():
    print 'reached'

def getFinal():
    return (solList,  playatpos, posList)

def IAmFinished(ID, group,  cln, luck,  stay,  payoff):
    global counter
    global dictators
    global ChoiceList
    if counter == 0:
        print '---------------------------------------------------'
    counter +=1
    print 'Player %s, of society %s, has ended the expriment, with payoff %s'%(ID, group, payoff)
    mainlist.append([ID, group, cln, luck, stay, payoff])
#    safe1 = open('Output/safe.out', 'a')
#    print >> safe1,  'player %s failsafe stats'%(counter),  mainlist[counter-1]
#    safe1.close()
    
    if counter == N:        
        print '---------------------------------------------------'
        print
        print 'The session is over. Have a look at stats.out for payoffs, stay-not stay, luck, payoff'
        #print statstics sheet
        statout = open('Output/stats.out', 'w')
        print >> statout,  'ID,  group, cln, luck,  stay,   payoff'
        mainlist.sort(key = lambda x:(x[3],x[0]))#sorting by group, subject
        for item in mainlist:
            string =       '%s,     %s,     %s,   %s,     %s,     %s'%(item[0], item[1], item[2], item[3], item[4], item[5])
            print >> statout,  string
        statout.close()
        #print payoff sheet
        print 'Payoffs and stay choice are in pay.out'
        payout = open('Output/pay.out', 'w')
        print >> payout,  'ID,  group,  clname, payoff,  stay'
        for item in mainlist:
            string =      '%s,   %s,    %s,       %s, %s'%(item[0], item[1], item[2], item[5], item[3])
            print >> payout,  string
        payout.close()
        print
        print 'Remember to copy the .out files to a safe location'
        print
        print 'Then delete them to be ready for the next session'
    return None


if __name__ == '__main__':
    # NOTE: CHANGE THIS TO MATCH THE SERVER ADDRESS ###############
    # example: if server is 170.192.1.1, type '170.192.1.1' (WITH quotation marks) instead of 'localhost'
    #server = SimpleXMLRPCServer(('144.32.151.119', 8200),  allow_none = True,  logRequests = False)
    server = SimpleXMLRPCServer(('144.32.151.119', 8200),  allow_none = True,  logRequests = False)
    ###############################################################
    
    #initing files for communication with clients
    f = open('Output/firstchoice', 'wb')
    f.close()
    f = open('Output/secondchoice', 'wb')
    f.close()
    ###############################################################
    
    #initing file for dictator and scenario choice
    legend = []
    f = open('legend.csv', 'wb')
    print >> f, 'Society, Player, atPC, Dict, Scenario'
    f.close()
    ###############################################################
    
    # inputs #########################################################
    while 1:
        Treatment = raw_input('Type of treatment [internal = int, external = ext]: ')
        if Treatment == 'int':
            while 1:
                N = input('Number of Players [multiple of 4]: ')
                if type(N) != int or N not in [4, 8, 12, 16, 20, 24, 28, 32, 36, 40]:
                    print 'Incorrect number. Try again\n'
                else: break
            break
        if Treatment == 'ext':
            while 1:
                N = input('Number of Players [multiple of 5]: ')
                if type(N) != int or N not in [5, 10, 15, 20, 25, 30, 35, 40, 45, 50]:
                        print 'Incorrect number. Try again\n'
                else: break
            break
        else:
            print 'I did not understand. int or ext?\n'
    while 1:
        Default = raw_input('Type of Default [div = equality of dividends, pay = equality of payments]: ')
        if Default == 'div' or Default == 'pay':
            break
        else:
            print 'I did not understand. div or pay?\n'
    ##################################################################
    
    # generate IDs and assign to groups###############################
    ID_group = []
    if Treatment == 'int':
        for j in range(1, N/4+1):
            for i in range(1, 5):
                ID_group.append([i, j])
    if Treatment == 'ext':
        for j in range(1, N/5+1):
            for i in range(1, 6):
                ID_group.append([i, j])
    ##################################################################
    
    # generate list where to store choices ###########################
    ChoiceList = []
    ChoiceFull = False
    dictators = []
    payperiods = []
    FinalList = []
    solList = []
    playatpos = []
    posList = []
    positions = 0
    cl_list = []
    ##################################################################
    
    #drawing the dictators
    DrawDictators()
    DrawPayPeriods()
    counter = 0
    mainlist = []
    
    #failsafe log
    safe1 = open('Output/safe.out', 'a')
    print >> safe1,  'ID,  group,  luck, stay'
    safe1.close()

    ###### Registering server functions ############################################################    
    server.register_function(GetDefault)
    server.register_function(getID)
    server.register_function(RegisterChoice)
    server.register_function(getDictator)
    server.register_function(RegisterFinal)
    server.register_function(getFinal)
    server.register_function(IAmFinished)
    server.register_function(getPayPeriod)
    server.register_function(getFinalData)
    server.register_function(Dummy)
    
    print '\n\nServer ready. waiting for clients...'    
    server.serve_forever()
