#!/usr/bin/python
import wx                                #GUI toolkit
import random                            #Create and handle pseudo-random numbers
import sympy                             #Manipulates symbolic computations
import time                              #sleeping before server calls
import os                                #used to check for file update for polling loop
from xmlrpclib import ServerProxy        #Manages connections with server

class Interlude(wx.Frame):
    """Interlude waiting screen, while waiting for the others to finish the game"""
    def __init__(self, type, *args, **kwds):
        wx.Frame.__init__(self, None, -1, **kwds)
        #init panel
        self.panel = wx.Panel(self,-1)
        self.wait = wx.StaticText(self.panel,  -1,  'Please wait for the others to complete their choices')
        self.wait.SetFont(wx.Font(18, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))
        
        #timers
        self.T1 = wx.Timer(self)
        self.T2 = wx.Timer(self)
        if type == 1:
            self.Bind(wx.EVT_TIMER, self.OnTimer, self.T1)
            self.T1.Start(500 + random.random()*200)
        if type == 2:
            self.Bind(wx.EVT_TIMER, self.OnSecondTimer, self.T2)
            self.T2.Start(500 + random.random()*500)
        
        self.__do_layout()
    
    def __do_layout(self):
        self.panel.SetSizer(centerStuff(self.wait))
        MAINsizer = wx.BoxSizer(wx.VERTICAL)
        MAINsizer.Add(self.panel, 1, wx.EXPAND)
        self.SetSizer(MAINsizer)
        MAINsizer.Fit(self)
        self.Layout()
    
    def OnTimer(self, event):
        """Event triggered when exiting the first waiting screen - after phase 1"""
        global firstchoicetime   
        global payper
        time.sleep(random.random())
        newtime1 = os.stat('Output/firstchoice').st_mtime
        if newtime1 > firstchoicetime:
            firstchoicetime = newtime1
            self.T1.Stop()
            self.Destroy()
            if ID == 5:
                PostA = PostScreenDict()
            else:
                PostA = PostScreenA()               
            PostA.ShowFullScreen(True, style=wx.FULLSCREEN_ALL)             
        else:
            pass

    def OnSecondTimer(self, event):
        """Event triggered when exiting the second waiting screen - after phase 2. It sets the stage for the final matrix"""
        global finalstay
        global secondchoicetime        
        time.sleep(random.random())
        newtime2 = os.stat('Output/secondchoice').st_mtime
        if newtime2 > secondchoicetime:
            self.T2.Stop()
            self.Destroy()

            if ID == 5:
                final = FinalScreen(2)
            else: 
                final = FinalScreen(1)
            final.ShowFullScreen(True, style=wx.FULLSCREEN_ALL)
            time.sleep(2*random.random()) #sleeps a random amount of time between 0 and 2 secs

            safecall(server.IAmFinished(ID, group, clname, finalluck, finalstay,  FPAY))
        else:
            pass

class PostScreenDict(wx.Frame):
    def __init__(self, *args, **kwds):
        wx.Frame.__init__(self, None, -1, **kwds)
        global FC
        
        self.Panel = wx.Panel(self, -1)
        self.Dictator,  self.DictatorChoice = safecall(server.getDictator(group))

        FC = self.DictatorChoice
        self.RelChoice = self.GenRelevantChoice(self.DictatorChoice)
        self.Identification = wx.StaticText(self.Panel, -1, 'Player %s, society %s: players will be paid according to\n\nScenario %s'%(ID, group, self.Reformat(payper)), style=wx.ALIGN_CENTRE)
        self.Identification.SetFont(wx.Font(18, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))        
        self.Dict = wx.StaticText(self.Panel,  -1,  "You have been chosen to be the dictator. The choice is:")
        self.Dict.SetFont(wx.Font(18, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))
        self.Explication1 = wx.StaticText(self.Panel,  -1,  'Your choice will be applied to the other players\n', style=wx.ALIGN_CENTRE)
        self.Explication2 = wx.StaticText(self.Panel,  -1,  'You will receive a fixed payement of %s'%(DictatorFixedPayment))
        self.Explication1.SetFont(wx.Font(14, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))
        self.Explication2.SetFont(wx.Font(16, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))
        self.ChoiceText = wx.StaticText(self.Panel,  -1,  "%s"%(self.DisplayChoice(self.RelChoice)))
        self.ChoiceText.SetFont(wx.Font(12, wx.MODERN, wx.NORMAL, wx.BOLD, 0, ""))
        
        self.OK = wx.Button(self.Panel, -1, 'OK', size =(150,50))
        self.OK.Bind(wx.EVT_BUTTON, self.OnOK)
        
        self.__do_layout()

    def __do_layout(self):
        self.Grid = wx.GridBagSizer(hgap = 5, vgap = 5)
        self.Grid.Add(centerStuff(self.Identification),  pos=(0, 0),  flag=wx.EXPAND |wx.ALIGN_CENTRE)
        self.Grid.Add(centerStuff(self.Dict),  pos=(1, 0),  flag=wx.EXPAND |wx.ALIGN_CENTRE)
        self.Grid.Add(centerStuff(self.ChoiceText),  pos=(2, 0),  flag=wx.EXPAND |wx.ALIGN_CENTRE)
        self.Grid.Add(centerStuff(self.Explication1),  pos=(3, 0),  flag=wx.EXPAND |wx.ALIGN_CENTRE)
        self.Grid.Add(centerStuff(self.Explication2),  pos=(4, 0),  flag=wx.EXPAND |wx.ALIGN_CENTRE)
        self.Grid.Add(centerStuff(self.OK),  pos=(5, 0),  flag=wx.EXPAND |wx.ALIGN_CENTRE)
        for i in range(0,6):
            self.Grid.AddGrowableRow(i)
        self.Grid.AddGrowableCol(0)
            
        self.Panel.SetSizer(self.Grid)
        self.Fit()
        self.Layout()

    def Reformat(self, p):
        if p == 1: return '1a'
        if p == 2: return '1b'
        if p == 3: return '2a'
        if p == 4: return '2b'
        if p == 5: return '3'

    def OnOK(self, event):
        self.Destroy()
        safecall(server.RegisterFinal(ID, group, finalluck, finalstay))
        interlude2 = Interlude(2)
        interlude2.ShowFullScreen(True, style=wx.FULLSCREEN_ALL)
        pass
    
    def GenRelevantChoice(self, ch):
        if payper == 1: return ch[2]
        if payper == 2: return ch[3]
        if payper == 3: return ch[0]
        if payper == 4: return ch[1]
        if payper == 5: return ch[4][0]

    def DisplayChoice(self, finalchoice):
        if payper == 3:
            c1 = 'For all members who have BAD luck:               '
            d1 = 'equality of dividend \n'
            d2 = 'equality of payment \n'
            if self.RelChoice == 1: c1 = c1 + d1
            if self.RelChoice == 2: c1 = c1 + d2
            return c1
        if payper == 4:
            c1 = 'For all members who have GOOD luck:               '
            d1 = 'equality of dividend \n'
            d2 = 'equality of payment \n'
            if self.RelChoice == 1: c1 = c1 + d1
            if self.RelChoice == 2: c1 = c1 + d2
            return c1
        if payper == 1:
            c1 = 'For all members who LEAVE:               '
            d1 = 'equality of dividend \n'
            d2 = 'equality of payment \n'
            if self.RelChoice == 1: c1 = c1 + d1
            if self.RelChoice == 2: c1 = c1 + d2
            return c1  
        if payper == 2:
            c1 = 'For all members who STAY:               '
            d1 = 'equality of dividend \n'
            d2 = 'equality of payment \n'
            if self.RelChoice == 1: c1 = c1 + d1
            if self.RelChoice == 2: c1 = c1 + d2
            return c1   
            
        if payper == 5:
            c1 = 'For all members who have BAD luck:               '
            c2 = 'For all members who have GOOD luck:              '
            c3 = 'For all members who LEAVE:                '
            c4 = 'For all members who STAY:                   '
            d1 = 'equality of dividend \n'
            d2 = 'equality of payment \n'
            for i in range(4):
                if self.RelChoice[i]==1: exec('c%s = c%s + d1'%(i+1, i+1))
                if self.RelChoice[i]==2: exec('c%s = c%s + d2'%(i+1, i+1))            
            return c1+c2+c3+c4   

class PostScreenA(wx.Frame):
    def __init__(self, *args, **kwds):
        wx.Frame.__init__(self, None, -1, **kwds)
        global FC
        
        self.Panel = wx.Panel(self, -1)
        
        self.Identification = wx.StaticText(self.Panel, -1, 'Member %s, society %s: Scenario %s has been randomly selected for your society.'%(ID, group, self.Reformat(payper)), style=wx.ALIGN_CENTRE)
        self.Identification.SetFont(wx.Font(18, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))
        
        self.ABRule = wx.StaticText(self.Panel, -1, 'Equality of Payments', style=wx.ALIGN_CENTRE)
        self.CDRule = wx.StaticText(self.Panel, -1, 'Equality of Payments', style=wx.ALIGN_CENTRE)
        self.ACRule = wx.StaticText(self.Panel, -1, 'Equality of Payments', style=wx.ALIGN_CENTRE)
        self.BDRule = wx.StaticText(self.Panel, -1, 'Equality of Payments', style=wx.ALIGN_CENTRE)
        RuleList = [self.ABRule, self.CDRule, self.ACRule, self.BDRule]
        for el in RuleList:
            el.SetFont(wx.Font(16, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))


        #badgoodluck button
        self.BadGoodButton = wx.Button(self.Panel, -1, 'Bad or Good Luck?', size=(150,50))
        self.BadGoodButton.Bind(wx.EVT_BUTTON, self.OnLuck)
        
        #stay/leave togglebuttons
        self.StayToggle = wx.ToggleButton(self.Panel, -1, 'Stay', size=(150,50))
        self.LeaveToggle = wx.ToggleButton(self.Panel, -1, 'Leave', size=(150,50))
        self.StayToggle.Bind(wx.EVT_TOGGLEBUTTON, self.OnStayToggle)
        self.LeaveToggle.Bind(wx.EVT_TOGGLEBUTTON, self.OnLeaveToggle)
        #they start as disabled
        self.LeaveToggle.Disable()
        self.StayToggle.Disable()

        self.Dictator,  self.DictatorChoice = safecall(server.getDictator(group))
        #testing bullshit
#        self.Dictator = 3
#        self.DictatorChoice = [1,1,2,2,[[1,2,2,1],1]]
        FC = self.DictatorChoice
        self.RelChoice = self.GenRelevantChoice(self.DictatorChoice)
        
        self.PPeriod = safecall(server.getPayPeriod(group))
        
        if self.Dictator == ID:
            self.Dict = wx.StaticText(self.Panel,  -1,  "You have been randomly selected to be your society's dictator.", style=wx.ALIGN_CENTRE)
        else:
            self.Dict = wx.StaticText(self.Panel,  -1,  "Member %s has been randomly selected to be your society's dictator."%(self.Dictator), style=wx.ALIGN_CENTRE)
        self.Dict.SetFont(wx.Font(18, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))

        self.Details = wx.StaticText(self.Panel, -1, "\n\nThe income values and the chosen dividend rules are shown in the table below.", style=wx.ALIGN_CENTRE)
        self.Details.SetFont(wx.Font(14, wx.DEFAULT, wx.NORMAL, wx.NORMAL, 0, ""))
        
        self.Ys = DisplayMatrix(self.Panel)       

        if payper == 3 or payper == 4:
            self.ToDo = wx.StaticText(self.Panel, -1, 'Please Choose whether to STAY or LEAVE for part 2, by clicking on one of the buttons.', style=wx.ALIGN_CENTRE)
        if payper == 1 or payper == 2:
            self.ToDo = wx.StaticText(self.Panel, -1, 'Please determine your LUCK, by clicking on the button.', style=wx.ALIGN_CENTRE)
        if payper == 5:
            self.ToDo = wx.StaticText(self.Panel, -1, 'Please determine your LUCK, by clicking on the button.', style=wx.ALIGN_CENTRE)
        self.ToDo.SetFont(wx.Font(16, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))  
        self.ToDo.SetForegroundColour('red')          
        
        #OK button, starts deactivated        
        self.OK = wx.Button(self.Panel, -1, 'OK', size=(150,50))
        self.OK.Bind(wx.EVT_BUTTON, self.OnOK)
        self.OK.Disable()
        
        self.Panel.Bind(wx.EVT_ENTER_WINDOW,  self.HideStuff) 
        self.Ys.Bind(wx.EVT_ENTER_WINDOW,  self.HideStuff) 
        
        self.__do_layout()
        
    def __do_layout(self):
        asdsx = wx.StaticText(self.Panel, -1, '')
        asddx = wx.StaticText(self.Panel, -1, '')
        self.SubGrid = wx.GridBagSizer(hgap = 5, vgap = 5)        
        self.SubGrid.Add(centerStuff(self.ABRule),        pos=(1, 0), span=(1,1),  flag=wx.EXPAND |wx.ALIGN_CENTRE)
        self.SubGrid.Add(centerStuff(self.CDRule),        pos=(2, 0), span=(1,1),  flag=wx.EXPAND |wx.ALIGN_CENTRE)
        self.SubGrid.Add(centerStuff(self.ACRule),        pos=(0, 1), span=(1,1),  flag=wx.EXPAND |wx.ALIGN_CENTRE)
        self.SubGrid.Add(centerStuff(self.BDRule),        pos=(0, 2), span=(1,1),  flag=wx.EXPAND |wx.ALIGN_CENTRE)
        self.SubGrid.Add(self.Ys,                         pos=(1, 1), span=(2,2),  flag=wx.EXPAND |wx.ALIGN_CENTRE)
        self.SubGrid.Add(centerStuff(self.BadGoodButton), pos=(1, 3), span=(2,1),  flag=wx.EXPAND |wx.ALIGN_CENTRE)
        self.SubGrid.Add(centerStuff(self.StayToggle),    pos=(3, 2), span=(1,1),  flag=wx.EXPAND |wx.ALIGN_CENTRE)
        self.SubGrid.Add(centerStuff(self.LeaveToggle),    pos=(3, 1), span=(1,1),  flag=wx.EXPAND |wx.ALIGN_CENTRE)
        self.SubGrid.AddGrowableRow(0)
        self.SubGrid.AddGrowableRow(1)
        self.SubGrid.AddGrowableRow(2)
        self.SubGrid.AddGrowableRow(3)
        self.SubGrid.AddGrowableCol(0)
        self.SubGrid.AddGrowableCol(1)
        self.SubGrid.AddGrowableCol(2)
        self.SubGrid.AddGrowableCol(3)
        
        self.Grid = wx.GridBagSizer(hgap = 5, vgap = 5)
        self.Grid.Add(centerStuff(self.Identification),  pos=(0, 0), span=(1,3),  flag=wx.EXPAND |wx.ALIGN_CENTRE)
        self.Grid.Add(centerStuff(self.Dict),  pos=(1, 0), span=(1,3), flag=wx.EXPAND |wx.ALIGN_CENTRE)
        self.Grid.Add(centerStuff(self.Details),  pos=(2, 0),  span=(1,3),flag=wx.EXPAND |wx.ALIGN_CENTRE)
        self.Grid.Add(self.SubGrid,  pos=(3, 1), span = (1,1),  flag=wx.EXPAND |wx.ALIGN_CENTRE)
        self.Grid.Add(asdsx,  pos=(3, 0), span = (1,1),  flag=wx.EXPAND |wx.ALIGN_CENTRE)
        self.Grid.Add(asddx,  pos=(3, 2), span = (1,1),  flag=wx.EXPAND |wx.ALIGN_CENTRE)
        self.Grid.Add(centerStuff(self.ToDo),  pos=(4, 0), span=(1,3), flag=wx.EXPAND |wx.ALIGN_CENTRE)
        self.Grid.Add(centerStuff(self.OK),  pos=(5, 0), span=(1,3), flag=wx.EXPAND |wx.ALIGN_CENTRE)
        self.Grid.AddGrowableRow(0, proportion = 1)
        self.Grid.AddGrowableRow(1, proportion = 1)
        self.Grid.AddGrowableRow(2, proportion = 1)
        self.Grid.AddGrowableRow(3, proportion = 8)
        self.Grid.AddGrowableRow(4, proportion = 1)
        self.Grid.AddGrowableRow(5, proportion = 1)
        self.Grid.AddGrowableCol(1)
            
        self.Panel.SetSizer(self.Grid)
        self.Fit()
        self.Layout()

    def OnLuck(self, event):
        global finalluck
        a = random.random()
        if a >= 0.5:
            finalluck = 0
            self.BadGoodButton.SetLabel('Bad')
            self.BadGoodButton.SetFont(wx.Font(13, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))
            for item in self.Ys.Clist+self.Ys.Dlist: item.Hide()
            asd = 'BAD'
        else:
            finalluck = 1
            self.BadGoodButton.SetLabel('Good')
            self.BadGoodButton.SetFont(wx.Font(13, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))
            for item in self.Ys.Alist+self.Ys.Blist: item.Hide()
            asd = 'GOOD'
        self.BadGoodButton.Disable()
        self.StayToggle.Enable()
        self.LeaveToggle.Enable()
        if payper == 3 or payper == 4:
            pass
        if payper == 1 or payper == 2:
            self.ToDo.SetLabel('Your luck is %s. Please click on OK to reveal the final outcome'%(asd))
            self.OK.Enable()
        if payper == 5:
            self.ToDo.SetLabel('Please Choose wheter to STAY or LEAVE for part 2.')

    def OnStayToggle(self, event):
        global finalstay
        finalstay = 1
        self.StayToggle.SetBackgroundColour(wx.RED)
        self.LeaveToggle.SetValue(False)
        self.LeaveToggle.SetBackgroundColour(wx.SystemSettings_GetColour(wx.SYS_COLOUR_MENUBAR))
        if self.LeaveToggle.GetValue() == True:
            self.LeaveToggle.SetValue(False)
        for item in self.Ys.Alist+self.Ys.Clist: item.Hide()
        self.LeaveToggle.Disable()
        self.StayToggle.Disable()
        asd = 'STAY'
        if payper == 3 or payper == 4:
            self.ToDo.SetLabel('You chose to %s. Please click on OK to reveal the final outcome'%(asd))
        if payper == 1 or payper == 2:
            pass
        if payper == 5:
            self.ToDo.SetLabel('You chose to %s. Please click on OK to reveal the final outcome'%(asd))
        self.OK.Enable()

    def OnLeaveToggle(self, event):
        global finalstay
        finalstay = 0
        self.LeaveToggle.SetBackgroundColour(wx.RED)
        self.StayToggle.SetValue(False)
        self.StayToggle.SetBackgroundColour(wx.SystemSettings_GetColour(wx.SYS_COLOUR_MENUBAR))
        if self.StayToggle.GetValue() == True:
            self.StayToggle.SetValue(False)  
        for item in self.Ys.Blist+self.Ys.Dlist: item.Hide()
        self.LeaveToggle.Disable()
        self.StayToggle.Disable()
        asd = 'LEAVE'
        if payper == 3 or payper == 4:
            self.ToDo.SetLabel('You chose to %s. Please click on OK to reveal the final outcome'%(asd))
        if payper == 1 or payper == 2:
            pass
        if payper == 5:
            self.ToDo.SetLabel('You chose to %s. Please click on OK to reveal the final outcome'%(asd))
        self.OK.Enable()

    def HideStuff(self, event):
        """Hides icons of players in matrix cells if they are not there"""
        if self.Ys.counter == 0 or self.Ys.counter == 1:
            if payper == 1:
                for item in self.Ys.Blist+self.Ys.Dlist: item.Hide()
                for item in [self.ABRule, self.CDRule, self.BDRule]: item.Hide()
                self.StayToggle.Hide()
                self.LeaveToggle.Hide()
            if payper == 2:
                for item in self.Ys.Alist+self.Ys.Clist: item.Hide()
                for item in [self.ABRule, self.CDRule, self.ACRule]: item.Hide()
                self.StayToggle.Hide()
                self.LeaveToggle.Hide()
            if payper == 3:
                for item in self.Ys.Clist+self.Ys.Dlist: item.Hide()
                for item in [self.BDRule, self.CDRule, self.ACRule]: item.Hide()
                self.StayToggle.Enable()
                self.LeaveToggle.Enable()
                self.BadGoodButton.Hide()
            if payper == 4:
                for item in self.Ys.Alist+self.Ys.Blist: item.Hide()  
                for item in [self.ABRule, self.BDRule, self.ACRule]: item.Hide()
                self.StayToggle.Enable()
                self.LeaveToggle.Enable()
                self.BadGoodButton.Hide()
            self.Ys.counter+=1     
            self.DisplayChoice()
        else: pass  

    def Reformat(self, p):
        if p == 1: return '1a'
        if p == 2: return '1b'
        if p == 3: return '2a'
        if p == 4: return '2b'
        if p == 5: return '3'

    def GenRelevantChoice(self, ch):
        if payper == 1: return ch[0]
        if payper == 2: return ch[1]
        if payper == 3: return ch[2]
        if payper == 4: return ch[3]
        if payper == 5: return ch[4][0]
    
    def OnOK(self, event):
        global finalluck
        global finalstay
        if payper == 1: finalstay = 0
        if payper == 2: finalstay = 1
        if payper == 3: finalluck = 0
        if payper == 4: finalluck = 1
        self.Destroy()
        safecall(server.RegisterFinal(ID, group, finalluck, finalstay))
        interlude2 = Interlude(2)
        interlude2.ShowFullScreen(True, style=wx.FULLSCREEN_ALL)

    def DisplayChoice(self):
        dr = self.DictatorChoice[4][1]
        if payper == 1:
            if self.RelChoice == 1: self.ACRule.SetLabel('Equality of Dividends')
            if self.RelChoice == 2: self.ACRule.SetLabel('Equality of Payments')
        if payper == 2:
            if self.RelChoice == 1: self.BDRule.SetLabel('Equality of Dividends')
            if self.RelChoice == 2: self.BDRule.SetLabel('Equality of Payments')
        if payper == 3:
            if self.RelChoice == 1: self.ABRule.SetLabel('Equality of Dividends')
            if self.RelChoice == 2: self.ABRule.SetLabel('Equality of Payments')
        if payper == 4:
            if self.RelChoice == 1: self.CDRule.SetLabel('Equality of Dividends')
            if self.RelChoice == 2: self.CDRule.SetLabel('Equality of Payments')            
        if payper == 5:
            if self.RelChoice[0] == 1 and dr != 1: self.ABRule.SetLabel('Equality of Dividends')
            if self.RelChoice[0] == 1 and dr == 1: self.ABRule.SetLabel('Equality of Dividends\n(droppable)')
            if self.RelChoice[0] == 2 and dr != 1: self.ABRule.SetLabel('Equality of Payments')
            if self.RelChoice[0] == 2 and dr == 1: self.ABRule.SetLabel('Equality of Payments\n(droppable)')
            if self.RelChoice[1] == 1 and dr != 2: self.CDRule.SetLabel('Equality of Dividends')
            if self.RelChoice[1] == 1 and dr == 2: self.CDRule.SetLabel('Equality of Dividends\n(droppable)')
            if self.RelChoice[1] == 2 and dr != 2: self.CDRule.SetLabel('Equality of Payments') 
            if self.RelChoice[1] == 2 and dr == 2: self.CDRule.SetLabel('Equality of Payments\n(droppable)') 
            if self.RelChoice[2] == 1 and dr != 3: self.ACRule.SetLabel('Equality of Dividends')
            if self.RelChoice[2] == 1 and dr == 3: self.ACRule.SetLabel('Equality of Dividends\n(droppable)')
            if self.RelChoice[2] == 2 and dr != 3: self.ACRule.SetLabel('Equality of Payments')
            if self.RelChoice[2] == 2 and dr == 3: self.ACRule.SetLabel('Equality of Payments\n(droppable)')
            if self.RelChoice[3] == 1 and dr != 4: self.BDRule.SetLabel('Equality of Dividends')
            if self.RelChoice[3] == 1 and dr == 4: self.BDRule.SetLabel('Equality of Dividends\n(droppable)')
            if self.RelChoice[3] == 2 and dr != 4: self.BDRule.SetLabel('Equality of Payments')
            if self.RelChoice[3] == 2 and dr == 4: self.BDRule.SetLabel('Equality of Payments\n(droppable)')
            
class PostScreenB(wx.Frame):
    def __init__(self, *args, **kwds):
        wx.Frame.__init__(self, None, -1, **kwds)
        
        self.Panel = wx.Panel(self, -1)

        self.Intro = wx.StaticText(self.Panel,  -1,  "Do you wish to STAY or LEAVE for part two?")
        self.Intro.SetFont(wx.Font(18, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))
        self.WorkChoice = wx.RadioBox(self.Panel, -1, "", wx.DefaultPosition, wx.DefaultSize, ['Leave      ',  'Stay', ''], 1, wx.RA_SPECIFY_ROWS|wx.NO_BORDER)
        self.WorkChoice.ShowItem(2,False)
        self.WorkChoice.SetSelection(2)
        self.WorkChoice.SetFont(wx.Font(14, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))
        self.WorkChoice.Bind(wx.EVT_RADIOBOX, self.OnWorkChoice)
        self.OK = wx.Button(self.Panel,  -1,  'OK',  size=(150, 50))
        self.OK.Bind(wx.EVT_BUTTON,  self.OnOK)
        self.OK.Disable()
        
        self.__do_layout()
        
    def __do_layout(self):
        self.Grid = wx.GridBagSizer(hgap = 5, vgap = 5)
        self.Grid.Add(centerStuff(self.Intro),  pos=(0, 0),  flag=wx.EXPAND |wx.ALIGN_CENTRE)
        self.Grid.Add(centerStuff(self.WorkChoice),  pos=(1, 0),  flag=wx.EXPAND |wx.ALIGN_CENTRE)
        self.Grid.Add(centerStuff(self.OK),  pos=(2, 0),  flag=wx.EXPAND |wx.ALIGN_CENTRE)
        for i in range(3):
            self.Grid.AddGrowableRow(i)
        self.Grid.AddGrowableCol(0)
        
        self.Panel.SetSizer(self.Grid)
        self.Fit()
        self.Layout()

    def OnOK(self, event):
        global finalluck
        global finalstay
        finalstay = self.WorkChoice.GetSelection()
        if payper == 3: finalluck = 0
        if payper == 4: finalluck = 1
        self.Destroy()
        safecall(server.RegisterFinal(ID, group, finalluck, finalstay))
        interlude2 = Interlude(2)
        interlude2.ShowFullScreen(True, style=wx.FULLSCREEN_ALL)
#        fs = FinalScreen(1)
#        fs.ShowFullScreen(True, style=wx.FULLSCREEN_ALL)
        #TODO: send to server

    def OnWorkChoice(self, event):
        self.OK.Enable()
    
class PostScreenC(wx.Frame):
    def __init__(self, *args, **kwds):
        wx.Frame.__init__(self, None, -1, **kwds)            

        self.Panel = wx.Panel(self, -1)
        
        self.Intro = wx.StaticText(self.Panel,  -1,  "By hitting the button, you will determine your luck")
        self.Intro.SetFont(wx.Font(18, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))
        self.DrawButton = wx.Button(self.Panel,  -1,  'Draw Luck',  size=(150, 50))
        self.DrawButton.Bind(wx.EVT_BUTTON,  self.DrawLuck)
        self.DrawResult = wx.StaticText(self.Panel,  -1,  "Your luck is        ")
        self.DrawResult.SetFont(wx.Font(14, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))
        self.OK = wx.Button(self.Panel,  -1,  'OK',  size=(150, 50))
        self.OK.Bind(wx.EVT_BUTTON, self.OnOK)
        self.OK.Disable()
        
        self.__do_layout()
        
    def __do_layout(self):        
        self.Grid = wx.GridBagSizer(hgap = 5, vgap = 5)
        self.Grid.Add(centerStuff(self.Intro),  pos=(0, 0), span=(1,1),  flag=wx.EXPAND |wx.ALIGN_CENTRE)
        self.Grid.Add(centerStuff(self.DrawButton),  pos=(1, 0), span=(1,1), flag=wx.EXPAND |wx.ALIGN_RIGHT)
        self.Grid.Add(centerStuff(self.DrawResult),  pos=(2, 0), span=(1,1), flag=wx.EXPAND |wx.ALIGN_LEFT)
        self.Grid.Add(centerStuff(centerStuff(self.OK)),  pos=(3, 0), span=(1,1), flag=wx.EXPAND |wx.ALIGN_CENTRE)
        self.Grid.AddGrowableRow(0, proportion = 4)
        self.Grid.AddGrowableRow(1, proportion = 1)
        self.Grid.AddGrowableRow(2, proportion = 1)
        self.Grid.AddGrowableRow(3, proportion = 4)
        self.Grid.AddGrowableCol(0)        
        
        self.Panel.SetSizer(self.Grid)
        self.Fit()
        self.Layout()
        
    def OnOK(self, event):
        global finalluck
        global finalstay
        if payper == 1: finalstay = 0
        if payper == 2: finalstay = 1
        if payper == 1 or payper == 2:
            self.Destroy()
            safecall(server.RegisterFinal(ID, group, finalluck, finalstay))
            interlude2 = Interlude(2)
            interlude2.ShowFullScreen(True, style=wx.FULLSCREEN_ALL)
        if payper == 5:
            self.Destroy()
            PostB = PostScreenB()
            PostB.ShowFullScreen(True, style=wx.FULLSCREEN_ALL)
        print ID, group, clname, finalluck, finalstay
        #TODO: send to server

    def DrawLuck(self, event):
        global finalluck
        self.OK.Enable()
        pass
        a = random.random()
        if a >= 0.5:
            luck = 'Bad'
            finalluck = 0
        else:
            luck = 'Good'
            finalluck = 1
#        #layout and notification
        self.DrawButton.Disable()
        self.DrawResult.SetLabel("Your luck is %s"%(luck))

#        log = open('Output/out_pl%s_gr%s.out'%(ID, group), 'a')
#        print >> log,  'luck',  luck
#        log.close()
        
class WaitScreen(wx.Frame):
    """Exec waiting screen. Nothing fancy. it incorporates a button for starting the game."""
    def __init__(self, *args, **kwds):
        wx.Frame.__init__(self, None, -1, **kwds)
        #init panel
        self.panel = wx.Panel(self,-1)
        self.welcome = wx.StaticText(self.panel,  -1,  'The University of York  -  Welcome to this experiment')
        self.welcome.SetFont(wx.Font(18, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))
        self.execimg = wx.Image('Data/exec.png', wx.BITMAP_TYPE_PNG)
        self.w = self.execimg.GetWidth()
        self.h = self.execimg.GetHeight()
        self.execimg2 = self.execimg.Scale(self.w/1, self.h/1)
        self.execimg2 = self.execimg2.ConvertToBitmap()
        self.img = wx.StaticBitmap(self.panel, -1, self.execimg2)
        self.text = wx.StaticText(self.panel,  -1,  'You are member %s of society %s'%(ID, group),  style=wx.ALIGN_CENTRE)
        self.waittext = wx.StaticText(self.panel,  -1,  "\nPlease wait.")
        self.subtext = wx.StaticText(self.panel,  -1,  "The default dividend rule for your society is %s"%self.genRule())
        
        self.text.SetFont(wx.Font(18, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))
        self.waittext.SetFont(wx.Font(18, wx.DEFAULT, wx.NORMAL, wx.BOLD,  0, ""))
        self.subtext.SetFont(wx.Font(14, wx.DEFAULT, wx.NORMAL, wx.BOLD,  0, ""))

        self.button = wx.Button(self.panel, -1, '', size=(120, 30), style=wx.NO_BORDER)
        self.button.Bind(wx.EVT_BUTTON,  self.OnActivation)
        self.__do_layout()

    def __do_layout(self):
        self.grid = wx.GridBagSizer(hgap=5, vgap=5)
        vbox = wx.BoxSizer(wx.VERTICAL)
        hbox = wx.BoxSizer(wx.HORIZONTAL)
        centerup = wx.BoxSizer(wx.VERTICAL)
        centerup.Add(self.welcome, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ALL, 1)
        
        centermiddle = wx.BoxSizer(wx.VERTICAL)
        centermiddle.Add(self.img, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ALL, 1)
        centermiddle.Add(self.text, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ALL, 5)
        centermiddle.Add(self.subtext, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ALL, 5)
        centermiddle.Add(self.waittext, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ALL, 5)
        hbox.Add(centermiddle,  1,  wx.EXPAND|wx.ALL, 5)
        
        centerdown = wx.BoxSizer(wx.VERTICAL)
        centerdown.Add(self.button,  1,  wx.EXPAND|wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ALL, 5)
        
        vbox.Add(centerup,  0,  wx.EXPAND|wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ALL, 5)
        vbox.Add(hbox,  1,  wx.EXPAND|wx.ALL, 5)
        vbox.Add(centerdown,  0,  wx.EXPAND|wx.ALL, 5)
        
        self.grid.Add(centerup, pos=(0, 1),  flag=wx.EXPAND|wx.ALIGN_CENTRE)
        self.grid.Add(hbox, pos=(2, 1),  flag=wx.EXPAND |wx.ALIGN_CENTRE)
        self.grid.Add(centerdown, pos=(4, 0), span=(1, 3),  flag=wx.EXPAND |wx.ALIGN_CENTRE)
        self.grid.AddGrowableRow(0,  proportion = 3)
        self.grid.AddGrowableRow(2,  proportion = 6)
        self.grid.AddGrowableRow(4,  proportion = 1)
        self.grid.AddGrowableCol(1)
        
        self.panel.SetSizer(self.grid)
        MAINsizer = wx.BoxSizer(wx.VERTICAL)
        MAINsizer.Add(self.panel, 1, wx.EXPAND)
        self.SetSizer(MAINsizer)
        MAINsizer.Fit(self)
        self.Layout()

    def genRule(self):
        global Default
        if Default == [1,0]: return 'EQUAL DIVIDENDS'
        else               : return 'EQUAL PAYMENTS'
        
    def OnActivation(self, event):
        self.Destroy()
        Sc1.ShowFullScreen(True, style=wx.FULLSCREEN_ALL)
        Sc1.panel.cronotimer.Start(1000)#milliseconds

class Matrix(wx.Panel):
    """Inits the matrix, and lays it out. All updates are done in the MainPanel class"""
    def __init__(self,  parent):
        wx.Panel.__init__(self, parent, -1)
        
        cellnames = self.GenCellNames()
        #Static Boxes############################
        self.ABox = wx.StaticBox(self,  -1,  cellnames[0])
        self.BBox = wx.StaticBox(self,  -1,  cellnames[1])
        self.CBox = wx.StaticBox(self,  -1,  cellnames[2])
        self.DBox = wx.StaticBox(self,  -1,  cellnames[3])
        #####################################
        
        #Players sub-grids############################
        #declaring stuff
        self.PlayIcons = {1: 'Data/pl1_small.png', 2: 'Data/pl2_small.png', 3:  'Data/pl3_small.png', 4: 'Data/pl4_small.png'}
        for i in ['A', 'B', 'C', 'D']:
            for name in self.PlayIcons:
                exec("self.img%s%s = wx.Image(self.PlayIcons[name], wx.BITMAP_TYPE_PNG)"%(i,  name))
                exec("self.img%s%sbmp = self.img%s%s.ConvertToBitmap()"%(i, name,  i, name))
                exec("self.bmp%s%s = wx.StaticBitmap(self, -1, self.img%s%sbmp)"%(i, name, i, name))

        #layout
        for i in ['A', 'B', 'C', 'D']:
            exec("self.grid%s = wx.GridBagSizer(5, 5)"%(i))
            exec("self.grid%s.Add(self.bmp%s1,  (0, 0),  (1, 1),  wx.ALIGN_CENTER)"%(i, i))
            exec("self.grid%s.Add(self.bmp%s2,  (0, 1),  (1, 1),  wx.ALIGN_CENTER)"%(i, i))
            exec("self.grid%s.Add(self.bmp%s3,  (0, 2),  (1, 1),  wx.ALIGN_CENTER)"%(i, i))
            exec("self.grid%s.Add(self.bmp%s4,  (0, 3),  (1, 1),  wx.ALIGN_CENTER)"%(i, i))
            exec("self.grid%s.AddGrowableRow(0)"%(i))
            exec("self.grid%s.AddGrowableCol(0)"%(i))
            exec("self.grid%s.AddGrowableCol(1)"%(i))
            exec("self.grid%s.AddGrowableCol(2)"%(i))
            exec("self.grid%s.AddGrowableCol(3)"%(i))
        #####################################
        
        #Static texts###################
        #Labels
        for i in ['A', 'B', 'C', 'D']:
            exec("self.%s_earn = wx.StaticText(self,  -1,  'Income',  style=wx.ALIGN_CENTRE)"%(i))
            exec("self.%s_transf = wx.StaticText(self,  -1,  'Dividend',  style=wx.ALIGN_CENTRE)"%(i))
            exec("self.%s_pay = wx.StaticText(self,  -1,  'Payment',  style=wx.ALIGN_CENTRE)"%(i))
        #Values
        for i in ['A', 'B', 'C', 'D']:
            exec("self.%s_transf_V = wx.StaticText(self,  -1,  '0.00',  style=wx.ALIGN_CENTRE)"%(i))
            exec("self.%s_pay_V = wx.StaticText(self,  -1,  '0.00',  style=wx.ALIGN_CENTRE)"%(i))
        
        #fixed values
        for i in ['A','D']:
            exec("self.%s_earn_V = wx.StaticText(self,  -1,  '0.00',  style=wx.ALIGN_CENTRE)"%(i))
        #spin boxes
        self.genSpinBoxes()  
                   
        #SetFont
        for i in ['A',  'B',  'C', 'D']:
            exec("self.%s_earn.SetForegroundColour('medium sea green')"%(i))
            exec("self.%s_earn_V.SetForegroundColour('medium sea green')"%(i))
            exec("self.%s_transf.SetForegroundColour('cadet blue')"%(i))
            exec("self.%s_transf_V.SetForegroundColour('cadet blue')"%(i))
            exec("self.%s_pay.SetForegroundColour('indian red')"%(i))
            exec("self.%s_pay_V.SetForegroundColour('indian red')"%(i))
            for j in ['earn', 'transf', 'pay']:
                exec("self.%s_%s.SetFont(wx.Font(12, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ''))"%(i, j))
                exec("self.%s_%s_V.SetFont(wx.Font(12, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ''))"%(i, j))
        
        #creates list of things to hide them
        for i in ['A',  'B',  'C', 'D']:
            exec('self.%slist = [self.%sBox, self.%s_earn, self.%s_earn_V, self.%s_transf, self.%s_transf_V,self.%s_pay, self.%s_pay_V]'%(i,i,i,i,i,i,i,i))
            for name in self.PlayIcons:            
                exec('self.%slist.append(self.bmp%s%s)'%(i,i,name))
        
        #Setting initial values for Ymin, Ymax (gotten from Mainpanel)
        self.A_earn_V.SetLabel('%s'%float(Ymin))
        self.D_earn_V.SetLabel('%s'%float(Ymax))
        self.B_earn_V.SetLabel('%s'%float(Ymiddle))
        self.C_earn_V.SetLabel('%s'%float(Ymiddle))
        ###########################

        self.counter = 0      
        self.BindToSpinBox()

        self.__do_layout()

    def genSpinBoxes(self):
        for i in ['B','C']:
            exec("self.%s_earn_V = wx.SpinCtrl(self, -1, '', (55,0), (50,-1))"%(i))
            exec("self.%s_earn_V.SetRange(Ymin,Ymax)"%(i))
            exec("self.%s_earn_V.SetValue(Ymiddle)"%(i))
            
    def BindToSpinBox(self):
        self.B_earn_V.Bind(wx.EVT_SPINCTRL, self.Parent.OnSpin1)
        self.C_earn_V.Bind(wx.EVT_SPINCTRL, self.Parent.OnSpin2)
    
    def refreshplaylist(self,  play_in_cell,  cell):
        """refreshes the list of players in a cell"""
        for player in range(1, 5):
            exec("self.bmp%s%s.Hide()"%(cell, player))
        for name in play_in_cell:
            exec("self.bmp%s%s.Show()"%(cell,  name))
    
    def GenCellNames(self):
        return ['Bad/Leave','Bad/Stay','Good/Leave','Good/Stay']
    
    def __do_layout(self):
        #StaticBoxSizers
        self.ABoxSizer = wx.StaticBoxSizer(self.ABox,  wx.VERTICAL)
        self.BBoxSizer = wx.StaticBoxSizer(self.BBox,  wx.VERTICAL)
        self.CBoxSizer = wx.StaticBoxSizer(self.CBox,  wx.VERTICAL)
        self.DBoxSizer = wx.StaticBoxSizer(self.DBox,  wx.VERTICAL)
        
        #Cell A,B,C,D subgrids ###############
        for i in ['A', 'B', 'C', 'D']:
            exec("self.%sSubGrid = wx.GridBagSizer(hgap=5,  vgap=5)"%(i))
            exec("self.%sSubGrid.Add(self.grid%s,  (0, 0),  (1, 2),  wx.ALIGN_LEFT|wx.EXPAND)"%(i, i))
            exec("self.%sSubGrid.Add(self.%s_earn,  (1, 0),  (1, 1),  wx.ALIGN_LEFT)"%(i, i))
            exec("self.%sSubGrid.Add(self.%s_earn_V,  (1, 1),  (1, 1),  wx.ALIGN_RIGHT)"%(i, i))
            exec("self.%sSubGrid.Add(self.%s_transf,  (2, 0),  (1, 1),  wx.ALIGN_LEFT)"%(i, i))
            exec("self.%sSubGrid.Add(self.%s_transf_V,  (2, 1),  (1, 1),  wx.ALIGN_RIGHT)"%(i, i))
            exec("self.%sSubGrid.Add(self.%s_pay,  (3, 0),  (1, 1),  wx.ALIGN_LEFT)"%(i, i))
            exec("self.%sSubGrid.Add(self.%s_pay_V,  (3, 1),  (1, 1),  wx.ALIGN_RIGHT)"%(i, i))
            for j in [0, 1]:
                exec("self.%sSubGrid.AddGrowableCol(%s)"%(i, j))
            for j in [0, 1, 2, 3]:
                exec("self.%sSubGrid.AddGrowableRow(%s)"%(i, j))
            exec("self.%sBoxSizer.Add(self.%sSubGrid,  1,  wx.EXPAND|wx.ALL,  10)"%(i, i))
        
        #main grid
        self.grid = wx.GridBagSizer(hgap=5,  vgap=5)
        self.grid.Add(self.ABoxSizer,  (0, 0),  (1, 1),  wx.EXPAND)
        self.grid.Add(self.BBoxSizer,  (0, 1),  (1, 1),  wx.EXPAND)
        self.grid.Add(self.CBoxSizer,  (1, 0),  (1, 1),  wx.EXPAND)
        self.grid.Add(self.DBoxSizer,  (1, 1),  (1, 1),  wx.EXPAND)
        for i in [0, 1]:
            self.grid.AddGrowableRow(i)
            self.grid.AddGrowableCol(i)
        
        self.SetSizer(self.grid)

class FinalMatrix(Matrix):
    def BindToSpinBox(self):
        self.B_earn_V.Disable()
        self.C_earn_V.Disable()
        
class DisplayMatrix(Matrix):
    def BindToSpinBox(self):
        l = [self.A_transf, self.B_transf, self.C_transf, self.D_transf, self.A_transf_V, self.B_transf_V, self.C_transf_V, self.D_transf_V, self.A_pay, self.B_pay, self.C_pay, self.D_pay, self.A_pay_V, self.B_pay_V, self.C_pay_V, self.D_pay_V]
        for element in l:
            element.Hide()

        # erasing players
        self.refreshplaylist([], 'A')
        self.refreshplaylist([], 'B')
        self.refreshplaylist([], 'C')
        self.refreshplaylist([], 'D')
        
        #revealing true values
        self.B_earn_V.SetLabel(str(YB))
        self.C_earn_V.SetLabel(str(YC))

        # hiding relevant columns/rows
        if payper == 1:
            for item in self.Blist+self.Dlist: item.Disable()
        if payper == 2:
            for item in self.Alist+self.Clist: item.Disable()
        if payper == 3:
            for item in self.Clist+self.Dlist: item.Disable()
        if payper == 4:
            for item in self.Alist+self.Blist: item.Disable()  
    def genSpinBoxes(self):
        for i in ['B','C']:
            exec("self.%s_earn_V = wx.StaticText(self,  -1,  '0.00',  style=wx.ALIGN_CENTRE)"%(i))

        
class FinalScreen(wx.Frame):
    """Displays the final choices to subjects, and tells them the result of the experiment"""
    def __init__(self, type,  *args, **kwds):
        wx.Frame.__init__(self, None,  -1,  **kwds)
        #init panel
        self.panel = wx.Panel(self,  -1)
        self.goodbye = wx.StaticText(self.panel,  -1,  'The University of York  -  Thanks for having taken part in this experiment.')
        self.goodbye.SetFont(wx.Font(18, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))
        self.matrix = FinalMatrix(self.panel)
        
        self.CloseButton = wx.Button(self.panel,  -1,  'Close the window and QUIT the experiment')
        self.CloseButton.Bind(wx.EVT_BUTTON,  self.OnClose)
        
        if type != 2:
            if finalluck == 0:
                luckcond ='BAD'
            else:
                luckcond = 'GOOD'
            if finalstay == 0:
                staycond = 'LEAVE for part 2'
            else:
                staycond = 'STAY for part 2'
            
            self.summary = wx.StaticText(self.panel,  -1,  'Player %s, society %s: you had %s luck, you chose to %s.'%(ID, group,  luckcond, staycond))
            self.finalpayoff = wx.StaticText(self.panel,  -1,  'Your final payoff is %s.'%(100))#get from server or from local var generated from server string.
            if finalstay == 1:
                self.staytext = wx.StaticText(self.panel, -1,  'The FIRST PART of the experiment is over. Please wait to be instructed for part 2.')
            else:
                self.staytext = wx.StaticText(self.panel, -1, 'The experiment is OVER. Please wait to receive your payment.')
            
            self.summary.SetFont(wx.Font(16, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))
            self.finalpayoff.SetFont(wx.Font(16, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))
            self.staytext.SetFont(wx.Font(16, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))
            
            self.__do_layout()
        
        if type == 2:
            self.summary = wx.StaticText(self.panel,  -1,  'Player %s, society %s: you are the dictator of this society.'%(ID, group))
            self.finalpayoff = wx.StaticText(self.panel,  -1,  'Your final payoff is %s'%(DictatorFixedPayment))#get from server or from local var generated from serve
            self.staytext = wx.StaticText(self.panel, -1, 'The experiment is OVER. Please wait to receive your payment')
            
            self.summary.SetFont(wx.Font(16, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))
            self.finalpayoff.SetFont(wx.Font(16, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))
            self.staytext.SetFont(wx.Font(16, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))
            
            self.__do_layout()
        
        self.FinalUpdate()
        self.Bind(wx.EVT_ENTER_WINDOW,  self.HideStuff) #bind to panel and test!
               
    def OnClose(self, event):
        self.Destroy()

    def GenRelevantChoice(self):
        global FC
        global drop
        drop = FC[4][1]
        print 'payper', payper
        print FC[0]
        print FC[1]
        print FC[2]
        print FC[3]
        print FC[4][0]
        if payper == 1: return ([1,1,FC[0],1], drop)
        if payper == 2: return ([1,1,1,FC[1]], drop)
        if payper == 3: return ([FC[2],1,1,1], drop)
        if payper == 4: return ([1,FC[3],1,1], drop)
        if payper == 5: return (FC[4][0], drop)
        
    def FinalUpdate(self):
        global FPAY
        self.pos = safecall(server.getFinalData(group))
        
        ch, dr = self.GenRelevantChoice()
        sol = self.Solver(ch,dr, self.pos)
        xa_semi, xb_semi, xc_semi, xd_semi = (0,0,0,0)
        unklist = sol.keys()
        try: 
            for unknown in unklist:
                exec("Trans%s = sol[%s]"%(str(unknown),  unknown))
                exec("%s_semi = round(float(Trans%s), 2)"%(unknown, unknown))
        
        except ValueError:
            pass
                                
        #refresh the matrix
        if xa_semi:
            self.matrix.A_transf_V.SetLabel(str(xa_semi))
        if xb_semi:
            self.matrix.B_transf_V.SetLabel(str(xb_semi))
        if xc_semi:
            self.matrix.C_transf_V.SetLabel(str(xc_semi))
        if xd_semi:
            self.matrix.D_transf_V.SetLabel(str(xd_semi))         
        self.matrix.B_earn_V.SetValue(YB)
        self.matrix.B_earn_V.Disable()
        self.matrix.C_earn_V.SetValue(YC)
        self.matrix.C_earn_V.Disable()
        self.GreyOutCells()
        self.ComputePayments()
        FPAY = self.getMyPay()
        if ID != 5:
            self.finalpayoff.SetLabel('Your final payoff is %s.'%(FPAY))
        if ID == 5:
            self.finalpayoff.SetLabel('Your final payoff is %s.'%(DictatorFixedPayment))
        

    def Solver(self, list, dr, pos):
        budget = xa*na + xb*nb + xc*nc + xd*nd - total
        
        #retrieving parameters
        at1,  at2,  at3,  at4 = pos
        numA, numB, numC, numD = (len(at1), len(at2), len(at3), len(at4))
        numatpos = [numA,numB,numC,numD]
        unk = [xa,xb,xc,xd]
        YA = Ymin
        YD = Ymax
        
        #substituting in budget
        budget = budget.subs({na:numA,  nb:numB,  nc:numC, nd:numD,  total:X})
        
        #setting up equation 1 (bad luck)
        if list[0] == 0: cond1 = 0
        if list[0] == 1: cond1 = xa - xb
        if list[0] == 2: cond1 = xa + ya - xb - yb
        #no constraint if no one is around
        if numA == 0 or numB == 0: cond1 = 0
        #substituting
        if cond1: cond1 = cond1.subs({ya: YA,  yb: YB})
        
        #setting up equation 2 (bad luck)
        if list[1] == 0: cond2 = 0
        if list[1] == 1: cond2 = xc - xd
        if list[1] == 2: cond2 = xc - xd + yc - yd
        #no constraint if no one is around
        if numC == 0 or numD == 0: cond2 = 0
        #substituting
        if cond2: cond2 = cond2.subs({yc: YC,  yd: YD})
        
        #setting up equation 3 (not stay)
        if list[2] == 0: cond3 = 0
        if list[2] == 1: cond3 = xa - xc
        if list[2] == 2: cond3 = xa + ya - xc - yc
        #no constraint if no one is around
        if numA == 0 or numC == 0: cond3 = 0            
        #substituting
        if cond3: cond3 = cond3.subs({ya: YA,  yc: YC})
        
        #setting up equation 4 (stay)
        if list[3] == 0: cond4 = 0
        if list[3] == 1: cond4 = xb - xd
        if list[3] == 2: cond4 = xb + yb - xd - yd
        #no constraint if no one is around
        if numB == 0 or numD == 0: cond4 = 0            
        #substituting
        if cond4: cond4 = cond4.subs({yb:YB,  yd:YD})
        
        #now, calling sympy.solve() function to solve the system. Returns a DICTIONARY.
        system = [budget,  cond1,  cond2,  cond3,  cond4]
        realunk = [w for w in unk if numatpos[unk.index(w)]!=0]
        constraints = [cond1,cond2,cond3,cond4]
        numz = (numA,numB,numC,numD)
        if constraints == [0,0,0,0]:
            if Default == [1,0]:
                if numA > 0: cond5 = xa-xd
                if numB > 0: cond5 = xc-xb
            else:
                if numA > 0: cond5 = xa + ya - xd - yd
                if numB > 0: cond5 = xc + yc - xb - yb
            if 4 in numz:
                if numz.index(4)==0: cond5 = xa-X/4
                if numz.index(4)==1: cond5 = xb-X/4
                if numz.index(4)==2: cond5 = xc-X/4
                if numz.index(4)==3: cond5 = xd-X/4
            cond5 = cond5.subs({ya:YA, yb:YB, yc:YC, yd:YD})
            system = [budget,  cond1,  cond2,  cond3,  cond4, cond5]
        s = sympy.solve(system, realunk)
        if s:
            return s
        else:
            if dr != 0:
                exec("cond%s = 0"%dr)
                system = [budget,  cond1,  cond2,  cond3,  cond4]
                realunk = [w for w in unk if numatpos[unk.index(w)]!=0]
                s = sympy.solve(system, realunk)
#                for item in self.DropList:
#                    item.Enable()
                return s
            else:
#                for item in self.DropList:
#                    item.Enable()
                print 'this should never happen'
                return 'D'

    def getMyPay(self):
        at1,at2,at3,at4 = self.pos
        if ID in at1: return self.matrix.A_pay_V.GetLabel()
        if ID in at2: return self.matrix.B_pay_V.GetLabel()
        if ID in at3: return self.matrix.C_pay_V.GetLabel()
        if ID in at4: return self.matrix.D_pay_V.GetLabel()
        
    def HideStuff(self, event):
        """Hides icons of players in matrix cells if they are not there"""
        if self.matrix.counter == 0 or self.matrix.counter == 1:
            #here we hide the relevant matrix cells
            self.UpdatePosPlayers() #TODO: 
            if payper == 1:
                for item in self.matrix.Blist+self.matrix.Dlist: item.Hide()
            if payper == 2:
                for item in self.matrix.Alist+self.matrix.Clist: item.Hide()
            if payper == 3:
                for item in self.matrix.Clist+self.matrix.Dlist: item.Hide()
            if payper == 4:
                for item in self.matrix.Alist+self.matrix.Blist: item.Hide()                
            self.matrix.counter+=1            
        else: pass  
    
    def CountAtPos(self):
        at1, at2, at3, at4 = ([1,2],[3,4],[],[])
        return (at1,at2,at3,at4)
    
    def UpdatePosPlayers(self):
        """Maps changes to playerposition radiobuttons to values in the matrix"""
        at1,at2,at3,at4 = self.pos
        self.matrix.refreshplaylist(at1, 'A')
        self.matrix.refreshplaylist(at2, 'B')
        self.matrix.refreshplaylist(at3, 'C')
        self.matrix.refreshplaylist(at4, 'D')
        return (at1, at2, at3, at4)

    def GreyOutCells(self):
        """Greys out and blanks the content of all cells that have num of players = 0"""
        self.UpdatePosPlayers()
        atA,  atB,  atC,  atD = self.pos
        for i in ['A', 'B', 'C', 'D']:
            exec('numatcell = len(at%s)'%(i))
            if numatcell == 0:
                exec('self.matrix.%s_transf_V.SetLabel("")'%(i))
                exec('self.matrix.%s_transf_V.Disable()'%(i))
                exec('self.matrix.%s_transf.Disable()'%(i))
                exec('self.matrix.%s_pay_V.SetLabel("")'%(i))
                exec('self.matrix.%s_pay_V.Disable()'%(i))
                exec('self.matrix.%s_pay.Disable()'%(i))
                exec('self.matrix.%s_earn_V.Disable()'%(i))
                exec('self.matrix.%s_earn.Disable()'%(i))
            else:
                exec('self.matrix.%s_transf.Enable()'%(i))
                exec('self.matrix.%s_transf_V.Enable()'%(i))
                exec('self.matrix.%s_pay.Enable()'%(i))
                exec('self.matrix.%s_pay_V.Enable()'%(i))
                exec('self.matrix.%s_earn.Enable()'%(i))   
                
    def ComputePayments(self):
        """Computes final payments in matrix - simple sum of values"""
        self.UpdatePosPlayers()
        at1, at2, at3, at4 = self.pos
        A, B, C, D = (len(at1), len(at2), len(at3), len(at4))
        for i in ['A', 'B', 'C', 'D']:
            exec("play = int(%s)"%(i))
            if play != 0:
                if i in ['A','D']:
                    exec("earn = float(self.matrix.%s_earn_V.GetLabel())"%(i))
                else:
                    exec("earn = float(self.matrix.%s_earn_V.GetValue())"%(i))                  
                exec("transf = float(self.matrix.%s_transf_V.GetLabel())"%(i))
                TOT = round((earn + transf),  2)
            else:
                TOT = 0.0
            exec("self.matrix.%s_pay_V.SetLabel('%s')"%(i, TOT))     
            
    def __do_layout(self):
        self.grid = wx.GridBagSizer(hgap=5, vgap=5)
        
        self.grid.Add(centerStuff(self.goodbye),  pos=(0, 0), span=(1, 3),  flag=wx.EXPAND |wx.ALIGN_CENTRE)
        self.grid.Add(self.matrix,  pos=(1, 1), span=(1, 1),  flag=wx.EXPAND |wx.ALIGN_CENTRE)
        self.grid.Add(centerStuff(self.summary),  pos=(2, 0), span=(1, 3),  flag=wx.EXPAND |wx.ALIGN_CENTRE)
        self.grid.Add(centerStuff(self.finalpayoff),  pos=(3, 0), span=(1, 3),  flag=wx.EXPAND |wx.ALIGN_CENTRE)
        self.grid.Add(centerStuff(self.staytext),  pos=(4, 0), span=(1, 3),  flag=wx.EXPAND |wx.ALIGN_CENTRE)
        self.grid.Add(centerStuff(self.CloseButton),  pos=(5, 0), span=(1, 3),  flag=wx.EXPAND |wx.ALIGN_CENTRE)
        
        self.grid.AddGrowableRow(0,  proportion = 2)
        self.grid.AddGrowableRow(1,  proportion = 5)
        self.grid.AddGrowableRow(2,  proportion = 1)
        self.grid.AddGrowableRow(3,  proportion = 1)
        self.grid.AddGrowableRow(4,  proportion = 1)
        self.grid.AddGrowableRow(5,  proportion = 1)
        self.grid.AddGrowableCol(1)
        
        self.panel.SetSizer(self.grid)
        MAINsizer = wx.BoxSizer(wx.VERTICAL)
        MAINsizer.Add(self.panel, 1, wx.EXPAND)
        self.SetSizer(MAINsizer)
        MAINsizer.Fit(self)
        self.Layout()
    
class NoSolutionDialog(wx.Dialog):
    def __init__(self, parent):
        wx.Dialog.__init__(self, parent, style=wx.CAPTION)

        self.text = wx.StaticText(self, -1, self.SetText(), style=wx.ALIGN_CENTRE)
        self.text.SetFont(wx.Font(14, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))

        if previousdrop != 0:
            self.expl = wx.StaticText(self, -1, '\nYour previous choice has been selected for you.\nYou can confirm it or change it.', style=wx.ALIGN_CENTRE)
        else: 
            self.expl = wx.StaticText(self, -1, '\n\n', style=wx.ALIGN_CENTRE)   
             
        self.BadLuckButton = wx.ToggleButton(self, -1, 'Bad Luck', size=(120,50))
        self.GoodLuckButton = wx.ToggleButton(self, -1, 'Good Luck', size=(120,50))
        self.NoWorkButton = wx.ToggleButton(self, -1, 'Leave', size=(120,50))
        self.WorkButton = wx.ToggleButton(self, -1, 'Stay', size=(120,50))
        self.BadLuckButton.Bind(wx.EVT_TOGGLEBUTTON, self.OnBL)
        self.GoodLuckButton.Bind(wx.EVT_TOGGLEBUTTON, self.OnGL)
        self.NoWorkButton.Bind(wx.EVT_TOGGLEBUTTON, self.OnNW)
        self.WorkButton.Bind(wx.EVT_TOGGLEBUTTON, self.OnW)

        self.ButList = [self.BadLuckButton, self.GoodLuckButton, self.NoWorkButton, self.WorkButton]
        self.OK = wx.Button(self, -1, 'OK', size=(120,50))
        self.OK.Bind(wx.EVT_BUTTON, self.OnOK)
        self.OK.Disable()
        
        self.SetPrevious()
        self.CheckOK()
        self.__do_layout()
        
    def Cntr(self,  Stuff):
        """Workhorse for centering widgets in __do_layout"""
        h = wx.BoxSizer(wx.HORIZONTAL)
        h.Add ((0,0), 1, wx.EXPAND)
        h.Add (Stuff, 0, wx.ALIGN_CENTER)
        h.Add ((0,0), 1, wx.EXPAND) 
        return h 

    def SetText(self):
        return "There is no solution for the chosen rules.\nPlease select one rule to be dropped"
        
    def SetPrevious(self):
        global previousdrop
        if previousdrop == 1: self.BadLuckButton.SetValue(True)
        if previousdrop == 2: self.GoodLuckButton.SetValue(True)
        if previousdrop == 3: self.NoWorkButton.SetValue(True)
        if previousdrop == 4: self.WorkButton.SetValue(True)
    
    def __do_layout(self):
        self.Grid = wx.GridBagSizer(hgap = 5, vgap = 5)
        self.Grid.Add(self.Cntr(self.text), pos=(0,0), span = (1,4), flag=wx.EXPAND|wx.ALIGN_CENTRE)
        self.Grid.Add(self.Cntr(self.expl), pos=(1,0), span = (1,4), flag=wx.EXPAND|wx.ALIGN_CENTRE)
        self.Grid.Add(self.Cntr(self.BadLuckButton), pos=(2,0), flag=wx.EXPAND|wx.ALIGN_CENTRE)
        self.Grid.Add(self.Cntr(self.GoodLuckButton), pos=(2,1), flag=wx.EXPAND|wx.ALIGN_CENTRE)
        self.Grid.Add(self.Cntr(self.NoWorkButton), pos=(2,2), flag=wx.EXPAND|wx.ALIGN_CENTRE)
        self.Grid.Add(self.Cntr(self.WorkButton), pos=(2,3), flag=wx.EXPAND|wx.ALIGN_CENTRE)
        self.Grid.Add(self.Cntr(self.OK), pos=(3,0), span=(1,4), flag=wx.EXPAND|wx.ALIGN_CENTRE)
        self.Box = wx.BoxSizer(wx.HORIZONTAL)
        self.Box.Add(self.Grid, 1, wx.ALIGN_CENTER | wx.ALL, 10)
        self.SetSizer(self.Box)
        self.Box.Fit(self)
        
    def OnBL(self, event):
        global drop
        drop = 1
        self.BadLuckButton.SetBackgroundColour(wx.RED)
        for item in self.ButList:
            if item != self.BadLuckButton:
                item.SetValue(False)
                item.SetBackgroundColour(wx.SystemSettings_GetColour(wx.SYS_COLOUR_MENUBAR))
                if item.GetValue() == True:
                    item.SetValue(False)
                    item.Enable()
        self.CheckOK()
    
    def OnGL(self, event):
        global drop
        drop = 2
        self.GoodLuckButton.SetBackgroundColour(wx.RED)
        for item in self.ButList:
            if item != self.GoodLuckButton:
                item.SetValue(False)
                item.SetBackgroundColour(wx.SystemSettings_GetColour(wx.SYS_COLOUR_MENUBAR))
                if item.GetValue() == True:
                    item.SetValue(False)
                    item.Enable()
        self.CheckOK()
                
    def OnNW(self, event):
        global drop
        drop = 3        
        self.NoWorkButton.SetBackgroundColour(wx.RED)
        for item in self.ButList:
            if item != self.NoWorkButton:
                item.SetValue(False)
                item.SetBackgroundColour(wx.SystemSettings_GetColour(wx.SYS_COLOUR_MENUBAR))
                if item.GetValue() == True:
                    item.SetValue(False)
                    item.Enable()
        self.CheckOK()
                    
    def OnW(self, event):
        global drop
        drop = 4       
        self.WorkButton.SetBackgroundColour(wx.RED)
        for item in self.ButList:
            if item != self.WorkButton:
                item.SetValue(False)
                item.SetBackgroundColour(wx.SystemSettings_GetColour(wx.SYS_COLOUR_MENUBAR))
                if item.GetValue() == True:
                    item.SetValue(False)
                    item.Enable()
        self.CheckOK()
                    
    def OnOK(self, event):
        global previousdrop
        global drop
        l = [self.Parent.ABDroppable, self.Parent.CDDroppable,self.Parent.ACDroppable,self.Parent.BDDroppable]
        values = [w.GetValue() for w in self.ButList]
        chosen = values.index(True)
        for i in l:
            i.SetValue(False)
        if chosen == 0: self.Parent.ABDroppable.SetValue(True)
        if chosen == 1: self.Parent.CDDroppable.SetValue(True)
        if chosen == 2: self.Parent.ACDroppable.SetValue(True)
        if chosen == 3: self.Parent.BDDroppable.SetValue(True)
        if chosen == 0: drop = 1
        if chosen == 1: drop = 2
        if chosen == 2: drop = 3
        if chosen == 3: drop = 4
        previousdrop = drop
        self.Parent.RefreshMatrix(solution, None)
        self.Destroy()

    def CheckOK(self):
        a = [w.GetValue() for w in self.ButList]
        if True in a and a.count(True) == 1: self.OK.Enable()
        else: self.OK.Disable()

class FinalNoSolDialog(NoSolutionDialog):
    def SetText(self):
        return "We need you to finally confirm your choice.\nPlease select the droppable rule."
    def OnOK(self, event):
        global previousdrop
        global drop
        values = [w.GetValue() for w in self.ButList]
        chosen = values.index(True)
        if chosen == 0: drop = 1
        if chosen == 1: drop = 2
        if chosen == 2: drop = 3
        if chosen == 3: drop = 4
        previousdrop = drop
        self.Destroy()        

class MainPanel(wx.Panel):
    """Main class initing and controlling the main panel of the game"""
    def __init__(self, parent):
        
        wx.Panel.__init__(self, parent, -1)
        
        # 4 panels for choosing ###########################################################################
        ###################################################################################################
        self.textlist = ['AB',  'CD',  'AC',  'BD']   
        global drop
        global choice        
        self.choice = choice
        self.drop = drop
        self.entercount = 0
        for i in self.textlist:
            exec("self.%spanel = wx.Panel(self,-1)"%i)
        
        #labels
        labels = self.genLabels()
        self.ABText = wx.StaticText(self.ABpanel,  -1,  labels[0],  style=wx.TE_CENTER|wx.TE_READONLY|wx.TE_MULTILINE|wx.TE_NO_VSCROLL|wx.EXPAND|wx.NO_BORDER)
        self.CDText = wx.StaticText(self.CDpanel,  -1,  labels[1],  style=wx.TE_CENTER|wx.TE_READONLY|wx.TE_MULTILINE|wx.TE_NO_VSCROLL|wx.EXPAND|wx.NO_BORDER)
        self.ACText = wx.StaticText(self.ACpanel,  -1,  labels[2],  style=wx.TE_CENTER|wx.TE_READONLY|wx.TE_MULTILINE|wx.TE_NO_VSCROLL|wx.EXPAND|wx.NO_BORDER)
        self.BDText = wx.StaticText(self.BDpanel,  -1,  labels[3],  style=wx.TE_CENTER|wx.TE_READONLY|wx.TE_MULTILINE|wx.TE_NO_VSCROLL|wx.EXPAND|wx.NO_BORDER)
            
        for item in self.textlist:
            exec("self.%sText.SetBackgroundColour(wx.SystemSettings_GetColour(wx.SYS_COLOUR_MENUBAR))"%item)
            exec('self.%sText.SetFont(wx.Font(12, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))'%item)
        
        #choice apparel
        for item in ['AB','CD']:
            exec("self.%sRadioChoice = wx.RadioBox(self.%spanel, -1, '', wx.DefaultPosition, wx.DefaultSize, ['d', 'Equality of Dividend', 'd', 'd', 'Equality of Payment','d'], 6, wx.RA_SPECIFY_ROWS | wx.NO_BORDER)"%(item,item))
            exec("self.%sRadioChoice.ShowItem(0, False)"%(item))
            exec("self.%sRadioChoice.ShowItem(2, False)"%(item))
            exec("self.%sRadioChoice.ShowItem(3, False)"%(item))
            exec("self.%sRadioChoice.ShowItem(5, False)"%(item))
        for item in ['AC','BD']:
            exec("self.%sRadioChoice = wx.RadioBox(self.%spanel, -1, '', wx.DefaultPosition, wx.DefaultSize, ['Equality of Dividend', 'Equality of Payment'], 2, wx.RA_SPECIFY_COLS | wx.NO_BORDER)"%(item,item))
        for item in self.textlist:            
            exec("self.%sDroppable = wx.CheckBox(self.%spanel, -1, 'Droppable')"%(item,item))
            exec("self.%sbox = wx.StaticBox(self.%spanel, -1, '')"%(item,item))

        #Enforce default        
        self.SetDefault()
        #Choice from RadioBox
        self.ABRadioChoice.Bind(wx.EVT_RADIOBOX, self.ABChoice)            
        self.ACRadioChoice.Bind(wx.EVT_RADIOBOX, self.ACChoice)            
        self.CDRadioChoice.Bind(wx.EVT_RADIOBOX, self.CDChoice)            
        self.BDRadioChoice.Bind(wx.EVT_RADIOBOX, self.BDChoice)            

        #Droppable Checkbox
        self.ABDroppable.Bind(wx.EVT_CHECKBOX, self.ABDrop)
        self.ACDroppable.Bind(wx.EVT_CHECKBOX, self.ACDrop)
        self.CDDroppable.Bind(wx.EVT_CHECKBOX, self.CDDrop)
        self.BDDroppable.Bind(wx.EVT_CHECKBOX, self.BDDrop)
        
        #
        ##################################################################################################
        
        #Static Boxes############################                             
        self.ControlBox = wx.StaticBox(self, -1, 'Control panel')
        self.ScenarioBox = wx.StaticBox(self, -1, '')
        ############################
        
        #Static Text############################                             #left
        self.InfoText = wx.StaticText(self, -1, self.GenInfoText())
        self.InfoText.SetFont((wx.Font(20, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, "")))
        ############################        

        #Timer #######################################
        self.totaltime = self.GetTime()
        self.hurrytime = self.GetHurryTime()
        self.cronotimer = wx.Timer(self)
        self.TimeDisplay = wx.StaticText(self, -1, '04:00', style = wx.ALIGN_CENTRE)
        self.TimeDisplay.SetFont(wx.Font(14, wx.DEFAULT,  wx.NORMAL,  wx.BOLD,  0,  ""))
        self.Bind(wx.EVT_TIMER, self.OnCrono, self.cronotimer)
        self.HurryTimer = wx.Timer(self)
        self.Bind(wx.EVT_TIMER, self.HurryUp, self.HurryTimer)
        ############################
        
        #Buttons############################
        #right
        self.ReselectButton = wx.Button(self,  -1,  'RePosition', size=(120,50))
        self.ReselectButton.Bind(wx.EVT_BUTTON,  self.OnReselect)

        #out
        self.AllDoneButton = wx.Button(self,  -1,  'Submit your choice', size=(240,100))
        self.AllDoneButton.SetFont(wx.Font(12, wx.DEFAULT,  wx.NORMAL,  wx.BOLD,  0,  ""))
        self.AllDoneButton.Bind(wx.EVT_BUTTON,  self.OnAllDone)
        self.AllDoneButton.Disable()
        ############################
        
        #Matrix ###############################
        self.matrix = self.GenMatrix()
        self.dMC = self.matrix
        ####################################
        
        #Sliders###############################      
        # Check the OnSlider1, Onslider2, functions
        ####################################
        
        #Player Positions ##########################
        self.Cells = self.GenCells()
        
        for i in range(1, 5):
            exec("self.pl%s = wx.RadioBox(self, -1, '', wx.DefaultPosition, wx.DefaultSize, self.Cells, 2, self.GenRadioType())"%(i))
            exec("self.img%s = wx.Image('Data/pl%s.png',  wx.BITMAP_TYPE_PNG).ConvertToBitmap()"%(i, i))
            exec("self.pl%simg = wx.StaticBitmap(self,  -1,  self.img%s, size=(self.img1.GetWidth(), self.img1.GetHeight()))"%(i, i))
        
        # set default position fo the players #########
        self.SetStartPosition()
        
        #bind event to radioboxes
        for i in range(1, 5):
            exec("self.pl%s.Bind(wx.EVT_RADIOBOX,  self.onPosPlayer)"%(i))
        
        self.ImplicationsStuff = [self.pl1,  self.pl2, self.pl3, self.pl4, self.pl1img, self.pl2img,  self.pl3img,  self.pl4img,  self.matrix,  self.ReselectButton]
        
        #Start disabling all the RIGHT side of the screen
        for item in self.ImplicationsStuff:
            item.Disable()
        ###############################
        
        #Display things ##############################
        self.__do_layout()
        
        #deleting players from the list
        self.Bind(wx.EVT_ENTER_WINDOW,  self.HidePlayers)
    
    def genLabels(self):
        log = open('Output/out_pl%s_gr%s.out'%(ID, group), 'a')
        print >> log,  '\n#####################################\n Entering Scenario 3 \n #############################\n'
        log.close()        
        return ('For all members\nwho have\nBAD luck', 'For all members\nwho have\nGOOD luck', 'For all members\nwho \nLEAVE', 'For all members\nwho \nSTAY')
    
    def SetStartPosition(self):
        for i in range(1, 5):
            exec("self.pl%s.SetSelection(%s)"%(i,i-1))
    
    def GetTime(self):
        return T[2]
    
    def GetHurryTime(self):
        return HT[2]
    
    def SetDefault(self):
        global Default
        lhor = [self.ABRadioChoice, self.CDRadioChoice]
        lver = [self.ACRadioChoice, self.BDRadioChoice]
        for item in lhor:
            item.SetSelection(Default[0])
        for item in lver:
            item.SetSelection(Default[1])
        if Default == [1,0]: self.choice = [1,1,1,1] #to change according to different default treatment
        else: self.choice = [2,2,2,2]
    
    def GenMatrix(self):
        return Matrix(self)

    def GenRadioType(self):
        return wx.RA_SPECIFY_COLS | wx.NO_BORDER
    
    def GenAllDoneButton(self):
        self.AllDoneButton.SetLabel('Submit your choice')
    
    def GenInfoText(self):
        return 'Scenario 3'

    def GenCells(self):
        return ['Bad/Leave',  'Bad/Stay',  'Good/Leave',  'Good/Stay']
    
    def HidePlayers(self, event):
        """Hides icons of players in matrix cells if they are not there"""
        if self.entercount == 0:
            self.SubmitChoices()
            self.UpdatePosPlayers()
            self.entercount+=1
    
    def TranslatePosition():
        pass
    
    #Block of events on RadioChoice radioboxes #########################################
    def TranslateChoice(self, widget):
        a = widget.GetSelection()
        if a == 1: return 1
        if a == 4: return 2
        
    def ABChoice(self, event):
        self.choice[0]= self.TranslateChoice(self.ABRadioChoice)
        self.SubmitChoices()
        
    def ACChoice(self, event):
        self.choice[2]= self.ACRadioChoice.GetSelection()+1
        self.SubmitChoices()        
        
    def CDChoice(self, event):
        self.choice[1]= self.TranslateChoice(self.CDRadioChoice)
        self.SubmitChoices()
        
    def BDChoice(self, event):
        self.choice[3]= self.BDRadioChoice.GetSelection()+1
        self.SubmitChoices()        
    ########################################################################################################  

    #Block of events on Droppable checkboxes ###############################################################  
    def ABDrop(self, event):
        global drop
        global previousdrop
        elselist = [self.ACDroppable, self.CDDroppable, self.BDDroppable]
        if self.ABDroppable.GetValue() == False:
            drop = 0
        if self.ABDroppable.GetValue() == True:
            drop = 1
            for item in elselist:
                item.SetValue(False)
        previousdrop = drop
        self.SubmitChoices()  

    def ACDrop(self, event):
        global drop
        global previousdrop
        elselist = [self.ABDroppable, self.CDDroppable, self.BDDroppable]
        if self.ACDroppable.GetValue() == False:
            drop = 0
        if self.ACDroppable.GetValue() == True:
            drop = 3
            for item in elselist:
                item.SetValue(False)
        previousdrop = drop                
        self.SubmitChoices()                  

    def CDDrop(self, event):
        global drop
        global previousdrop
        elselist = [self.ACDroppable, self.ABDroppable, self.BDDroppable]
        if self.CDDroppable.GetValue() == False:
            drop = 0
        if self.CDDroppable.GetValue() == True:
            drop = 2
            for item in elselist:
                item.SetValue(False)
        previousdrop = drop
        self.SubmitChoices()                  

    def BDDrop(self, event):
        global drop
        global previousdrop
        elselist = [self.ACDroppable, self.CDDroppable, self.ABDroppable]
        if self.BDDroppable.GetValue() == False:
            drop = 0
        if self.BDDroppable.GetValue() == True:
            drop = 4
            for item in elselist:
                item.SetValue(False) 
        previousdrop = drop        
        self.SubmitChoices()                  
    ########################################################################################################  
    
    def SubmitChoices(self):
        """Activates right part of the screen, greys out left part; starts the solver"""
        #calls the solver
        global choice, solution, drop
        choice = self.choice
        self.Parent.panel.RefreshMatrix(solution, None)
        for item in self.Parent.panel.ImplicationsStuff: item.Enable()
        log = open('Output/out_pl%s_gr%s.out'%(ID, group), 'a')
        print >> log,  choice
        log.close()    
    
    def OnCrono(self,  event):
        """Main timer, manageing the countdown, keeping 'submit' button grey, displaying the time"""
        mins = int(self.totaltime/60)
        rsecs = self.totaltime % 60     #same results as t - mins * 60
        self.TimeDisplay.SetLabel("%d:%02d" % (mins, rsecs))
        if self.totaltime == 0:
            self.cronotimer.Stop()
            self.GenAllDoneButton()
            self.AllDoneButton.Enable()
            self.HurryTimer.Start(1000)
        self.totaltime -= 1
    
    def HurryUp(self, event):
        """Second Timer, to hurry people up"""
        mins = int(self.hurrytime/60)
        rsecs = self.hurrytime % 60     #same results as t - mins * 60
        self.TimeDisplay.SetLabel("%d:%02d" % (mins, rsecs))
        if self.hurrytime == 30:
            self.TimeDisplay.SetForegroundColour(wx.RED)
        if self.hurrytime == 0:
            self.HurryTimer.Stop()
            self.EndChoice()
        self.hurrytime -= 1
    
    def OnAllDone(self, event):
        self.EndChoice()
        
    def EndChoice(self):
        """Triggered when phase 1 is over. Register choices, activates waiting screen, start polling Timer1"""
        global choice, drop
        if drop == 0:
            if self.choice == [1,1,1,1] or self.choice == [2,2,2,2]:
                pass
            else:
                finaldialog = FinalNoSolDialog(self)
                finaldialog.ShowModal()            
        allchoices.append([self.choice,drop])
        safecall(server.RegisterChoice(ID, group, allchoices))
        log = open('Output/out_pl%s_gr%s.out'%(ID, group), 'a')
        print >> log, 'final choice',  allchoices
        log.close()
        Sc3.Destroy()
        interlude = Interlude(1)
        interlude.ShowFullScreen(True,  style=wx.FULLSCREEN_ALL)

    
    def OnReselect(self, event):
        """selects a new set of parameters for Y and positions, and tells the matrix to refresh"""
#        vals = range(int(Ymin),  int(Ymax+1))
#        #generating random slider values and moving the sliders
#        self.dMC.B_earn_V.SetValue(float(random.choice(vals)))
#        self.dMC.C_earn_V.SetValue(float(random.choice(vals)))
        
        #generating random positions and moving the radiobuttons
        pos = self.GenPosRange()
        for i in range(1, 5):
            exec("self.pl%s.SetSelection(random.choice(pos))"%(i))
        
        # collect stats
        log = open('Output/out_pl%s_gr%s.out'%(ID, group), 'a')
        print >> log,  'ReSelect'
        log.close()
        
        self.RefreshMatrix(solution, None)

    def GenPosRange(self):
        return [0,1,2,3]
    
    def RefreshMatrix(self, solution, typ):
        """refreshes matrix values"""
        #computes solution
        global draws
        global drop
        
        solution = self.Solver(choice, drop)
        #players at pos
        atA,  atB,  atC,  atD = self.UpdatePosPlayers()
        numA, numB, numC, numD = (len(atA), len(atB), len(atC), len(atD))
        xa_semi, xb_semi, xc_semi, xd_semi = (0,0,0,0)
        if solution != 'D':
            unklist = solution.keys()
            drop = 0           
#            self.ReDrawButton.Disable()
            basicsubs = {}
            pl1v = self.pl1.GetSelection()
            pl2v = self.pl2.GetSelection()
            pl3v = self.pl3.GetSelection()
            pl4v = self.pl4.GetSelection()
            sl1v = self.dMC.B_earn_V.GetValue()
            sl2v = self.dMC.C_earn_V.GetValue()
            lasts.update({'pl1':pl1v,  'pl2':pl2v,  'pl3':pl3v,  'pl4':pl4v,  'sl1':sl1v,  'sl2':sl2v})
        
            try: 
                for unknown in unklist:
                    exec("Trans%s = solution[%s]"%(str(unknown),  unknown))
                    exec("%s_semi = round(float(Trans%s), 2)"%(unknown, unknown))
            
            except ValueError:
                pass
                                    
            #refresh the matrix
            if xa_semi:
                self.matrix.A_transf_V.SetLabel(str(xa_semi))
            if xb_semi:
                self.matrix.B_transf_V.SetLabel(str(xb_semi))
            if xc_semi:
                self.matrix.C_transf_V.SetLabel(str(xc_semi))
            if xd_semi:
                self.matrix.D_transf_V.SetLabel(str(xd_semi))                
        
        if solution == 'D':
            if self.totaltime > 0:
                self.cronotimer.Stop()
            DropSomething = NoSolutionDialog(self)
            DropSomething.ShowModal()
            if self.totaltime > 0:
                self.cronotimer.Start(1000)
         
            
        self.ComputePayments()
        self.GreyOutCells()
        payz = [self.matrix.A_pay_V.GetLabel(), self.matrix.B_pay_V.GetLabel(), self.matrix.C_pay_V.GetLabel(), self.matrix.D_pay_V.GetLabel()]
        payz2 = [0 if w == '' else float(w) for w in payz]
        
        try:
            log = open('Output/out_pl%s_gr%s.out'%(ID, group), 'a')
            print >> log,  'Number at position: %s; Dividend: %s; Payoff: %s'%((numA, numB, numC, numD), (xa_semi, xb_semi, xc_semi, xd_semi), (payz2))
            log.close()
        except UnboundLocalError:
            log = open('Output/out_pl%s_gr%s.out'%(ID, group), 'a')
            print >> log,  'No solution for the chosen parameters'
            log.close()
    
    def FindFreeUnknown(self, sol):
        """"From a dictionary solution, find the free unknown and return it"""
        unk = [xa,xb,xc,xd]
        ret = []
        for i in unk:
            if str(i) in str(sol.values()) and i not in sol.keys():
                ret.append(i)
        return ret
        
    def GreyOutCells(self):
        """Greys out and blanks the content of all cells that have num of players = 0"""
        atA,  atB,  atC,  atD = self.UpdatePosPlayers()
        for i in ['A', 'B', 'C', 'D']:
            exec('numatcell = len(at%s)'%(i))
            if numatcell == 0:
                exec('self.matrix.%s_transf_V.SetLabel("")'%(i))
                exec('self.matrix.%s_transf_V.Disable()'%(i))
                exec('self.matrix.%s_transf.Disable()'%(i))
                exec('self.matrix.%s_pay_V.SetLabel("")'%(i))
                exec('self.matrix.%s_pay_V.Disable()'%(i))
                exec('self.matrix.%s_pay.Disable()'%(i))
                exec('self.matrix.%s_earn_V.Disable()'%(i))
                exec('self.matrix.%s_earn.Disable()'%(i))
            else:
                exec('self.matrix.%s_transf.Enable()'%(i))
                exec('self.matrix.%s_transf_V.Enable()'%(i))
                exec('self.matrix.%s_pay.Enable()'%(i))
                exec('self.matrix.%s_pay_V.Enable()'%(i))
                exec('self.matrix.%s_earn_V.Enable()'%(i))
                exec('self.matrix.%s_earn.Enable()'%(i))

    
    def Solver(self, list, dr):
        global solution
        global drop
        budget = xa*na + xb*nb + xc*nc + xd*nd - total
        
        #retrieving parameters
        at1,  at2,  at3,  at4 = self.UpdatePosPlayers()
        numA, numB, numC, numD = (len(at1), len(at2), len(at3), len(at4))
        numatpos = [numA,numB,numC,numD]
        unk = [xa,xb,xc,xd]
        YA = Ymin
        YB = self.dMC.B_earn_V.GetValue()
        YC = self.dMC.C_earn_V.GetValue()
        YD = Ymax
        
        #substituting in budget
        budget = budget.subs({na:numA,  nb:numB,  nc:numC, nd:numD,  total:X})
        
        #setting up equation 1 (bad luck)
        if list[0] == 0: cond1 = 0
        if list[0] == 1: cond1 = xa - xb
        if list[0] == 2: cond1 = xa + ya - xb - yb
        #no constraint if no one is around
        if numA == 0 or numB == 0: cond1 = 0
        #substituting
        if cond1: cond1 = cond1.subs({ya: YA,  yb: YB})
        
        #setting up equation 2 (bad luck)
        if list[1] == 0: cond2 = 0
        if list[1] == 1: cond2 = xc - xd
        if list[1] == 2: cond2 = xc - xd + yc - yd
        #no constraint if no one is around
        if numC == 0 or numD == 0: cond2 = 0
        #substituting
        if cond2: cond2 = cond2.subs({yc: YC,  yd: YD})
        
        #setting up equation 3 (not stay)
        if list[2] == 0: cond3 = 0
        if list[2] == 1: cond3 = xa - xc
        if list[2] == 2: cond3 = xa + ya - xc - yc
        #no constraint if no one is around
        if numA == 0 or numC == 0: cond3 = 0            
        #substituting
        if cond3: cond3 = cond3.subs({ya: YA,  yc: YC})
        
        #setting up equation 4 (stay)
        if list[3] == 0: cond4 = 0
        if list[3] == 1: cond4 = xb - xd
        if list[3] == 2: cond4 = xb + yb - xd - yd
        #no constraint if no one is around
        if numB == 0 or numD == 0: cond4 = 0            
        #substituting
        if cond4: cond4 = cond4.subs({yb:YB,  yd:YD})
        
        #now, calling sympy.solve() function to solve the system. Returns a DICTIONARY.
        system = [budget,  cond1,  cond2,  cond3,  cond4]
        realunk = [w for w in unk if numatpos[unk.index(w)]!=0]
        constraints = [cond1,cond2,cond3,cond4]
        numz = (numA,numB,numC,numD)
        if constraints == [0,0,0,0]:
            if Default == [1,0]:
                if numA > 0: cond5 = xa-xd
                if numB > 0: cond5 = xc-xb
            else:
                if numA > 0: cond5 = xa + ya - xd - yd
                if numB > 0: cond5 = xc + yc - xb - yb
            if 4 in numz:
                if numz.index(4)==0: cond5 = xa-X/4
                if numz.index(4)==1: cond5 = xb-X/4
                if numz.index(4)==2: cond5 = xc-X/4
                if numz.index(4)==3: cond5 = xd-X/4
            cond5 = cond5.subs({ya:YA, yb:YB, yc:YC, yd:YD})
            system = [budget,  cond1,  cond2,  cond3,  cond4, cond5]
        solution = sympy.solve(system, realunk)
        if solution:
            return solution
        else:
            if dr != 0:
                exec("cond%s = 0"%dr)
                system = [budget,  cond1,  cond2,  cond3,  cond4]
                realunk = [w for w in unk if numatpos[unk.index(w)]!=0]
                solution = sympy.solve(system, realunk)
#                for item in self.DropList:
#                    item.Enable()
                return solution
            else:
#                for item in self.DropList:
#                    item.Enable()
                return 'D'
            
        
    def onPosPlayer(self, event):
        """Event bound to any change in playerpositions radiobuttons"""
        self.RefreshMatrix(solution, None)
        log = open('Output/out_pl%s_gr%s.out'%(ID, group), 'a')
        print >> log,  'PosPlayer'
        log.close()

    def OnSpin1(self,  event):
        """Action bound to right/top spinbox"""
        atA,  atB,  atC,  atD = self.UpdatePosPlayers()
        numA, numB, numC, numD = (len(atA), len(atB), len(atC), len(atD))
        if numB != 0:
            self.RefreshMatrix(solution, 'slider')
        log = open('Output/out_pl%s_gr%s.out'%(ID, group), 'a')
        print >> log,  'Spinbox 1 moved to %s'%(float(self.dMC.B_earn_V.GetValue()))
        log.close()
    
    def OnSpin2(self,  event):
        """Action bound to left/bottom slider"""
        atA,  atB,  atC,  atD = self.UpdatePosPlayers()
        numA, numB, numC, numD = (len(atA), len(atB), len(atC), len(atD))
        if numC != 0:
            self.RefreshMatrix(solution, 'slider')
        log = open('Output/out_pl%s_gr%s.out'%(ID, group), 'a')
        print >> log,  'Spinbox 2 moved to %s'%(float(self.dMC.C_earn_V.GetValue()))
        log.close()

    def DeclareAllPlayerLists(self):
        """Declares all player grids so that they are known by __do_layout of matrix and main panel"""
        for cell in ['A',  'B',  'C', 'D']:
            for player in range(1, 5):
                exec("self.matrix.bmp%s%s.Show()"%(cell, player))
    
    def CountAtPos(self):
        positions = []
        at1, at2, at3, at4 = ([],[],[],[])
        for i in range(1, 5):
            exec("pos%s = self.pl%s.GetSelection()+1"%(i, i))
            exec("positions.append(pos%s)"%(i))
        for i in range(len(positions)):
            exec("at%s.append(%s)"%(positions[i], i+1))
        return (at1,at2,at3,at4)
    
    def UpdatePosPlayers(self):
        """Maps changes to playerposition radiobuttons to values in the matrix"""
        at1, at2, at3, at4 = self.CountAtPos()
        self.matrix.refreshplaylist(at1, 'A')
        self.matrix.refreshplaylist(at2, 'B')
        self.matrix.refreshplaylist(at3, 'C')
        self.matrix.refreshplaylist(at4, 'D')
        return (at1, at2, at3, at4)

    def ComputePayments(self):
        """Computes final payments in matrix - simple sum of values"""
        at1, at2, at3, at4 = self.CountAtPos()
        A, B, C, D = (len(at1), len(at2), len(at3), len(at4))
        for i in ['A', 'B', 'C', 'D']:
            exec("play = int(%s)"%(i))
            if play != 0:
                if i in ['A','D']:
                    exec("earn = float(self.matrix.%s_earn_V.GetLabel())"%(i))
                else:
                    exec("earn = float(self.matrix.%s_earn_V.GetValue())"%(i))                    
                exec("transf = float(self.matrix.%s_transf_V.GetLabel())"%(i))
                TOT = round((earn + transf),  2)
            else:
                TOT = 0.0
            exec("self.matrix.%s_pay_V.SetLabel('%s')"%(i, TOT))

    def __do_layout(self):
        # Choice panels: ABpanel, CDpanel ###########
        for item in ['AB','CD']:
            exec("self.%sgrid = wx.GridBagSizer(hgap=5, vgap=5)"%item)
            exec("self.%sgrid.Add(centerStuff(self.%sText), pos=(0, 0), span=(2,1), flag=wx.EXPAND|wx.ALIGN_CENTRE)"%(item, item))
            exec("self.%sgrid.Add(centerStuff(self.%sRadioChoice), pos=(0,1),span=(2,1), flag=wx.EXPAND|wx.ALIGN_CENTRE)"%(item,item))
            exec("self.%sgrid.Add(centerStuff(self.%sDroppable), pos=(0,2), span= (2,1), flag=wx.EXPAND|wx.ALIGN_CENTRE)"%(item,item))
            exec("self.%sgrid.AddGrowableRow(0)"%item)
#            exec("self.%sgrid.AddGrowableRow(1)"%item)
            exec("self.%sgrid.AddGrowableCol(0)"%item)
            exec("self.%sgrid.AddGrowableCol(1)"%item)
            exec("self.%sgrid.AddGrowableCol(2)"%item)
            
            exec("self.%sboxsizer = wx.StaticBoxSizer(self.%sbox, wx.VERTICAL)"%(item,item))
            exec("self.%sboxsizer.Add(self.%sgrid,1,wx.EXPAND|wx.ALL,2)"%(item,item))
            
            exec("self.%spanel.SetSizer(self.%sboxsizer)"%(item,item))
        
        # Choice panels: ACpanel, BDpanel ###########
        for item in ['AC','BD']:
            exec("self.%sgrid = wx.GridBagSizer(hgap=5, vgap=5)"%item)
            exec("self.%sgrid.Add(centerStuff(self.%sText), pos=(0, 0), span=(1,2), flag=wx.ALIGN_CENTRE)"%(item, item))
            exec("self.%sgrid.Add(centerStuff(self.%sRadioChoice), pos=(1,0),span=(1,2), flag=wx.ALIGN_CENTRE)"%(item,item))
            exec("self.%sgrid.Add(centerStuff(self.%sDroppable), pos=(2,0), span=(1,2), flag=wx.ALIGN_CENTRE)"%(item,item))
            exec("self.%sgrid.AddGrowableRow(0)"%item)
            exec("self.%sgrid.AddGrowableRow(1)"%item)
            exec("self.%sgrid.AddGrowableRow(2)"%item)
            exec("self.%sgrid.AddGrowableCol(0)"%item)
#            exec("self.%sgrid.AddGrowableCol(1)"%item)
            
            exec("self.%sboxsizer = wx.StaticBoxSizer(self.%sbox, wx.VERTICAL)"%(item,item))
            exec("self.%sboxsizer.Add(self.%sgrid,1,wx.EXPAND|wx.ALL,2)"%(item,item))
            
            exec("self.%spanel.SetSizer(self.%sboxsizer)"%(item,item))
        ####################################################    
        
        # Player Positions SubBox#################
        self.WhereGrid = wx.GridBagSizer(hgap=5, vgap=5)
        self.WhereGrid.Add(centerStuff(self.pl1img),  (0, 0),  (1, 1),  wx.EXPAND|wx.ALIGN_CENTER)
        self.WhereGrid.Add(centerStuff(self.pl1),  (0, 1),  (1, 1),  wx.EXPAND|wx.ALIGN_CENTER)
        self.WhereGrid.Add(centerStuff(self.pl2img),  (0, 2),  (1, 1),  wx.EXPAND|wx.ALIGN_CENTER)
        self.WhereGrid.Add(centerStuff(self.pl2),  (0, 3),  (1, 1),  wx.EXPAND|wx.ALIGN_CENTER)
        self.WhereGrid.Add(centerStuff(self.pl3img),  (1, 0),  (1, 1),  wx.EXPAND|wx.ALIGN_CENTER)
        self.WhereGrid.Add(centerStuff(self.pl3),  (1, 1),  (1, 1),  wx.EXPAND|wx.ALIGN_CENTER)
        self.WhereGrid.Add(centerStuff(self.pl4img),  (1, 2),  (1, 1),  wx.EXPAND|wx.ALIGN_CENTER)
        self.WhereGrid.Add(centerStuff(self.pl4),  (1, 3),  (1, 1),  wx.EXPAND|wx.ALIGN_CENTER)
        self.WhereGrid.AddGrowableCol(1)
        self.WhereGrid.AddGrowableCol(3)
        self.PlayPositions = centerStuff(self.WhereGrid)
        ##############################
        
        # final layout #######################
        self.ControlBoxsizer = wx.StaticBoxSizer(self.ControlBox, wx.VERTICAL)
        self.ScenarioBoxSizer = wx.StaticBoxSizer(self.ScenarioBox, wx.VERTICAL)
        
        self.ContrBox = wx.GridBagSizer(hgap=5, vgap=5)
        self.ContrBox.Add(centerStuff(self.PlayPositions), pos=(0,0), span=(2,1), flag=wx.EXPAND|wx.ALIGN_CENTER)
#        self.ContrBox.Add(centerStuff(self.ReDrawButton), pos=(0,3), flag=wx.EXPAND|wx.ALIGN_CENTER)
        self.ContrBox.Add(centerStuff(self.TimeDisplay), pos=(0,5), span=(1,1), flag=wx.EXPAND|wx.ALIGN_CENTER)
        self.ContrBox.Add(centerStuff(self.ReselectButton), pos=(0,3), span=(2,1), flag=wx.EXPAND|wx.ALIGN_CENTER)
        self.ContrBox.Add(centerStuff(self.AllDoneButton), pos=(1,5), span=(1,1),  flag=wx.EXPAND|wx.ALIGN_CENTER)
        self.ContrBox.AddGrowableRow(0)
        self.ContrBox.AddGrowableRow(1)
        self.ContrBox.AddGrowableCol(0)
        self.ControlBoxsizer.Add(self.ContrBox, 1, wx.EXPAND|wx.ALL, 5)
        
        self.FinalGrid = wx.GridBagSizer(hgap=5, vgap=5)
        self.FinalGrid.Add(centerStuff(self.InfoText), pos=(0,0), flag=wx.EXPAND|wx.ALIGN_CENTER)
        self.FinalGrid.Add(self.dMC, pos = (1,1), span=(2,2), flag = wx.EXPAND|wx.ALIGN_CENTER)
        self.FinalGrid.Add(self.ABpanel, pos = (1,0), flag = wx.EXPAND|wx.ALIGN_CENTER)
        self.FinalGrid.Add(self.CDpanel, pos = (2,0), flag = wx.EXPAND|wx.ALIGN_CENTER)
        self.FinalGrid.Add(self.ACpanel, pos = (0,1), flag = wx.EXPAND|wx.ALIGN_CENTER)
        self.FinalGrid.Add(self.BDpanel, pos = (0,2), flag = wx.EXPAND|wx.ALIGN_CENTER)        
        self.FinalGrid.AddGrowableRow(0)
        self.FinalGrid.AddGrowableRow(1)
        self.FinalGrid.AddGrowableRow(2)
        self.FinalGrid.AddGrowableRow(3)
        self.FinalGrid.AddGrowableCol(0)
        self.FinalGrid.AddGrowableCol(1)
        self.FinalGrid.AddGrowableCol(2)
        self.ScenarioBoxSizer.Add(self.FinalGrid, 1, wx.EXPAND|wx.ALL, 5)
        
        self.MainGrid = wx.GridBagSizer(hgap=5, vgap=5)
        self.MainGrid.Add(self.ScenarioBoxSizer, pos=(0,0), flag=wx.EXPAND|wx.ALIGN_CENTER)
        self.MainGrid.Add(centerStuff(self.ControlBoxsizer), pos=(1,0), flag=wx.EXPAND|wx.ALIGN_CENTER)
        self.MainGrid.AddGrowableRow(0, proportion = 6)
        self.MainGrid.AddGrowableRow(1, proportion = 3)
        self.MainGrid.AddGrowableCol(0)
        self.MainGrid.AddGrowableCol(1)
        
        self.SetSizer(self.MainGrid)
        self.MainGrid.Fit(self)
        ###################################
        
        self.DeclareAllPlayerLists()        

class Scenario2(MainPanel):
    def genLabels(self):
        log = open('Output/out_pl%s_gr%s.out'%(ID, group), 'a')
        print >> log,  '\n#####################################\n Entering Scenario 2a \n #############################\n'
        log.close()        
        return ('All members\nhave\nBAD luck', 'For all members\nwho have\nGOOD luck', 'For all members\nwho \nLEAVE', 'For all members\nwho \nSTAY')    
    def GenPosRange(self):
        return [0,1]
        
    def SetStartPosition(self):
        for i in [1,2]:
            exec("self.pl%s.SetSelection(0)"%(i))
        for i in [3,4]:
            exec("self.pl%s.SetSelection(1)"%(i))
            
    def GetTime(self):
        return T[0]

    def GetHurryTime(self):
        return HT[0] 
            
    def GenCells(self):
        return ['Bad/Leave','Bad/Stay']
    
    def GenAllDoneButton(self):
        self.AllDoneButton.SetLabel('Submit your choice') 

    def GenInfoText(self):
        return 'Scenario 2a'        
    
    def HidePlayers(self, event):
        """Hides icons of players in matrix cells if they are not there"""
        if self.entercount == 0:
            #here we hide the relevant matrix cells
            self.UpdatePosPlayers()
            for item in self.matrix.Clist+self.matrix.Dlist:
                item.Hide()
            #here we hide the relevant choice boxes
            for i in ['CD',  'AC',  'BD']:
                exec("self.%spanel.Hide()"%i)
            self.SubmitChoices()
            #hiding the 'drop this' checkbox
            self.ABDroppable.Hide()
            self.entercount+=1            
        else: pass

    def EndChoice(self):
        """Triggered when phase 1 is over. Register choices, activates waiting screen, start polling Timer1"""
        allchoices.append(self.choice[0])
        Sc2.Destroy()
        Sc2b.ShowFullScreen(True, style=wx.FULLSCREEN_ALL)
        Sc2b.panel.cronotimer.Start(1000)#milliseconds

class Scenario2b(Scenario2):
    def genLabels(self):
        log = open('Output/out_pl%s_gr%s.out'%(ID, group), 'a')
        print >> log,  '\n#####################################\n Entering Scenario 2b \n #############################\n'
        log.close()
        return ('All members\nhave\nBAD luck', 'All members\nhave\nGOOD luck', 'For all members\nwho \nLEAVE', 'For all members\nwho \nSTAY')        
    def GenCells(self):
        return ['Good/Leave','Good/Stay']

    def GenInfoText(self):
        return 'Scenario 2b'

    def GenAllDoneButton(self):
        self.AllDoneButton.SetLabel('Submit your choice') 
        
    def HidePlayers(self, event):
        """Hides icons of players in matrix cells if they are not there"""
        if self.entercount == 0:
            #here we hide the relevant matrix cells
            self.UpdatePosPlayers()
            for item in self.matrix.Alist+self.matrix.Blist:
                item.Hide()
            #here we hide the relevant choice boxes
            for i in ['AB',  'AC',  'BD']:
                exec("self.%spanel.Hide()"%i)
            self.SubmitChoices()
            #hiding the 'drop this' checkbox
            self.CDDroppable.Hide()
            self.entercount+=1            
        else: pass

    def EndChoice(self):
        """Triggered when phase 1 is over. Register choices, activates waiting screen, start polling Timer1"""
        allchoices.append(self.choice[1])
        Sc2b.Destroy()
        Sc3.ShowFullScreen(True, style=wx.FULLSCREEN_ALL)
        Sc3.panel.cronotimer.Start(1000)#milliseconds    

    def CountAtPos(self):
        positions = []
        at1, at2, at3, at4 = ([],[],[],[])
        for i in range(1, 5):
            exec("pos%s = self.pl%s.GetSelection()+3"%(i, i))
            exec("positions.append(pos%s)"%(i))
        for i in range(len(positions)):
            exec("at%s.append(%s)"%(positions[i], i+1))
        return (at1,at2,at3,at4)

class Scenario1(MainPanel):
    def genLabels(self):
        log = open('Output/out_pl%s_gr%s.out'%(ID, group), 'a')
        print >> log,  '\n#####################################\n Entering Scenario 1a \n #############################\n'
        log.close()
        return ('All members\nhave\nBAD luck', 'For all members\nwho have\nGOOD luck', 'All members\nLEAVE', 'For all members\nwho \nSTAY')        
    def GenPosRange(self):
        return [0,1]
        
    def SetStartPosition(self):
        for i in [1,2]:
            exec("self.pl%s.SetSelection(0)"%(i))
        for i in [3,4]:
            exec("self.pl%s.SetSelection(1)"%(i))
    
    def GetTime(self):
        return T[1]

    def GetHurryTime(self):
        return HT[1]        
            
    def GenCells(self):
        return ['Bad/Leave',  'Good/Leave']
    
    def GenRadioType(self):
        return wx.RA_SPECIFY_ROWS | wx.NO_BORDER

    def GenAllDoneButton(self):
        self.AllDoneButton.SetLabel('Submit your choice')
        
    def GenInfoText(self):
        return 'Scenario 1a'        

    def CountAtPos(self):
        positions = []
        at1, at2, at3, at4 = ([],[],[],[])
        for i in range(1, 5):
            exec("pos%s = self.pl%s.GetSelection()+1"%(i, i))
            exec("if pos%s == 2: pos%s +=1"%(i,i))
            exec("positions.append(pos%s)"%(i))
        for i in range(len(positions)):
            exec("at%s.append(%s)"%(positions[i], i+1))
        return (at1,at2,at3,at4)
        
    def HidePlayers(self, event):
        """Hides icons of players in matrix cells if they are not there"""
        if self.entercount == 0:
            #here we hide the relevant matrix cells
            for item in self.matrix.Blist+self.matrix.Dlist:
                item.Hide()
            self.UpdatePosPlayers()
            #here we hide the relevant choice boxes
            for i in ['AB','CD', 'BD']:
                exec("self.%spanel.Hide()"%i)
            self.SubmitChoices() 
            #hiding the 'drop this' checkbox
            self.ACDroppable.Hide()
            self.entercount+=1
        else:
            pass
        
    def OnAllDone(self, event):
        self.EndChoice()
        
    def EndChoice(self):
        """Triggered when phase 1 is over. Register choices, activates waiting screen, start polling Timer1"""
        allchoices.append(self.choice[2])
        Sc1.Destroy()
        Sc1b.ShowFullScreen(True, style=wx.FULLSCREEN_ALL)
        Sc1b.panel.cronotimer.Start(1000)#milliseconds

class Scenario1b(Scenario1):
    def genLabels(self):
        log = open('Output/out_pl%s_gr%s.out'%(ID, group), 'a')
        print >> log,  '\n#####################################\n Entering Scenario 1b \n #############################\n'
        log.close()
        return ('All members\nhave\nBAD luck', 'For all members\nwho have\nGOOD luck', 'For all members\nwho \nLEAVE', 'All members\nSTAY')        
    def GenCells(self):
        return ['Bad/Stay',  'Good/Stay']   

    def GenAllDoneButton(self):
        self.AllDoneButton.SetLabel('Submit your choice') 

    def HidePlayers(self, event):
        """Hides icons of players in matrix cells if they are not there"""
        if self.entercount == 0:
            #here we hide the relevant matrix cells
            for item in self.matrix.Alist+self.matrix.Clist:
                item.Hide()
            self.UpdatePosPlayers()
            #here we hide the relevant choice boxes
            for i in ['AB','CD', 'AC']:
                exec("self.%spanel.Hide()"%i)
            self.SubmitChoices() 
            #hiding the 'drop this' checkbox
            self.BDDroppable.Hide()
            self.entercount+=1
        else: pass

    def GenInfoText(self):
        return 'Scenario 1b'          

    def EndChoice(self):
        """Triggered when phase 1 is over. Register choices, activates waiting screen, start polling Timer1"""
        allchoices.append(self.choice[3])
        Sc1b.Destroy()
        Sc2.ShowFullScreen(True, style=wx.FULLSCREEN_ALL)
        Sc2.panel.cronotimer.Start(1000)#milliseconds  

    def CountAtPos(self):
        positions = []
        at1, at2, at3, at4 = ([],[],[],[])
        for i in range(1, 5):
            exec("if self.pl%s.GetSelection()== 0: pos%s = 2"%(i,i))
            exec("if self.pl%s.GetSelection()== 1: pos%s = 4"%(i,i))
#            exec("pos%s = self.pl%s.GetSelection()+1"%(i, i))
            exec("positions.append(pos%s)"%(i))
        for i in range(len(positions)):
            exec("at%s.append(%s)"%(positions[i], i+1))
        return (at1,at2,at3,at4)        

class GF(wx.Frame):
    """General class, pass type of panel as argument"""
    def __init__(self, paneltype, *args, **kwds):
        wx.Frame.__init__(self, None, -1, **kwds)
        self.panel = paneltype(self)
        self.Fit()
        self.Layout() 
        

if __name__ == "__main__":
    def centerStuff(Stuff):
        h = wx.BoxSizer(wx.HORIZONTAL)
        h.Add ((0,0), 1, wx.EXPAND)
        h.Add (Stuff, 0, wx.ALIGN_CENTER)
        h.Add ((0,0), 1, wx.EXPAND) 
        return h 

    def safecall(call):
        c = 0
        while c < 10:
            try:
                a = call
                break
            except:
                time.sleep(1)
                c +=1     
        return a

    # CHANGE THESE PARAMETERS TO FIT WITH YOUR DESIRES #####################
    # York server is: 144.32.151.119:8200
    server = ServerProxy("http://144.32.151.119:8200",  allow_none=True) #connects with the server        
    
    #parameters are now hard-coded in THIS part############
    DictatorFixedPayment = 15
    Ymin = 0.0
    Ymax = 10.0
    T = (5,5,10) #First timer, in seconds. first number sets for 1a,1b; second for 2a,2b; third for 3
    HT = (10,10,10)  #second timer, in seconds. first number sets for 1a,1b; second for 2a,2b; third for 3
    YB = 7.0 #value in pounds - when changing, keep the .0 format
    YC = 8.0 #value in pounds - when changing, keep the .0 format
    ###
    
    
    # fixed parameters
    Ymiddle = Ymin + (Ymax - Ymin)/2
    X = 40.0    
    FC = 0 #Final-reallyFinal choice
    FPAY = 0 #final reallyfinal payoff
    clname = str(os.getenv('COMPUTERNAME'))[-2:]
    DefaultTreat = safecall(server.GetDefault())
    if DefaultTreat == 'div':
        Default = [1,0] #this is for 'eq dividend'. for 'eq payments' set [4,1]
    else: Default = [4,1]
    #######################################################
    #################################################################################
    
    #setting up the sympy variables needed by the solver (and other routines)#########
    xa, xb, xc, xd = sympy.symbols('xa, xb, xc, xd')
    na, nb, nc, nd = sympy.symbols('na, nb, nc, nd')
    ya, yb, yc, yd = sympy.symbols('ya, yb, yc, yd')
    total = sympy.Symbol('total')
    solution = 0 #initializes a 'solution' as a global variable
    draws = 0
    if Default == [1,0]:
        choice = [1, 1, 1, 1] #intializes a 'choice' variable
    else:
        choice = [2, 2, 2, 2] #intializes a 'choice' variable
    drop = 0 #init the constraint you would like to drop
    previousdrop = 0 #used to remember the previous the constraint you would like to drop
    controller = [0, 0] #used to catch only the first 'wx.ENTER_WINDOW' event [a bad hack]
    lasts = {'pl1':0,  'pl2':0,  'pl3':0,  'pl4':0,  'sl1':Ymiddle,  'sl2':Ymiddle}#to store default, then updated to last, values
    finalPosition = []
    finalSolution = []
    ########################################################
    
    # asking own ID and group to the server, starting the DATA storage file###################
#    time.sleep(random.random())
    ID,  group = safecall(server.getID(clname))
    log = open('Output/out_pl%s_gr%s.out'%(ID, group), 'wb')
    log.close()
    finalluck = 100
    finalstay = 100
    #######################################################
    
    # getting the time the polling files where last refreshed #############################
    firstchoicetime = os.stat('Output/firstchoice').st_mtime
    secondchoicetime = os.stat('Output/secondchoice').st_mtime
    #######################################################    
    
    # all choices #############################
    allchoices = []
    payper = safecall(server.getPayPeriod(group))
    
    #setting up the GUI####################################
    app = wx.PySimpleApp(0)
    wx.InitAllImageHandlers()
    waitscreen = WaitScreen()
    Sc1  = GF(Scenario1)
    waitscreen.ShowFullScreen(True, style=wx.FULLSCREEN_ALL)
    Sc1b = GF(Scenario1b)
    Sc2  = GF(Scenario2)
    Sc2b = GF(Scenario2b)
    Sc3  = GF(MainPanel)
#    P = PostScreenA()
#    P.ShowFullScreen(True, style=wx.FULLSCREEN_ALL)
    app.MainLoop()
